/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.zzl;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbof;
import com.google.android.gms.internal.zzbok;
import com.google.android.gms.internal.zzbql;
import com.google.android.gms.internal.zzbuh;
import com.google.android.gms.internal.zzbui;
import com.google.android.gms.internal.zzflr;
import com.google.android.gms.internal.zzfls;

public class DriveId
extends zzbgl
implements ReflectedParcelable {
    private static final zzal zza = new zzal("DriveId", "");
    public static final int RESOURCE_TYPE_UNKNOWN = -1;
    public static final int RESOURCE_TYPE_FILE = 0;
    public static final int RESOURCE_TYPE_FOLDER = 1;
    public static final Parcelable.Creator<DriveId> CREATOR = new zzl();
    private String zzb;
    private long zzc;
    private long zzd;
    private int zze;
    private volatile String zzf = null;
    private volatile String zzg = null;

    @Hide
    public static DriveId zza(String string) {
        zzbq.zza((Object)string);
        return new DriveId(string, -1L, -1L, -1);
    }

    public String getResourceId() {
        return this.zzb;
    }

    public int getResourceType() {
        return this.zze;
    }

    public DriveFile asDriveFile() {
        if (this.zze == 1) {
            throw new IllegalStateException("This DriveId corresponds to a folder. Call asDriveFolder instead.");
        }
        return new zzbof(this);
    }

    public DriveFolder asDriveFolder() {
        if (this.zze == 0) {
            throw new IllegalStateException("This DriveId corresponds to a file. Call asDriveFile instead.");
        }
        return new zzbok(this);
    }

    public DriveResource asDriveResource() {
        if (this.zze == 1) {
            return this.asDriveFolder();
        }
        if (this.zze == 0) {
            return this.asDriveFile();
        }
        return new zzbql(this);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DriveId driveId = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)driveId.zzb, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (long)driveId.zzc);
        zzbgo.zza((Parcel)parcel2, (int)4, (long)driveId.zzd);
        zzbgo.zza((Parcel)parcel2, (int)5, (int)driveId.zze);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    @Hide
    public DriveId(String string, long l, long l2, int n) {
        this.zzb = string;
        zzbq.zzb((!"".equals(string) ? 1 : 0) != 0);
        zzbq.zzb((string != null || l != -1L ? 1 : 0) != 0);
        this.zzc = l;
        this.zzd = l2;
        this.zze = n;
    }

    public int hashCode() {
        if (this.zzc == -1L) {
            return this.zzb.hashCode();
        }
        String string = String.valueOf(String.valueOf(this.zzd));
        String string2 = String.valueOf(String.valueOf(this.zzc));
        return (string2.length() != 0 ? string.concat(string2) : new String(string)).hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != DriveId.class) {
            return false;
        }
        DriveId driveId = (DriveId)((Object)object);
        if (driveId.zzd != this.zzd) {
            return false;
        }
        if (driveId.zzc == -1L && this.zzc == -1L) {
            return driveId.zzb.equals(this.zzb);
        }
        if (this.zzb == null || driveId.zzb == null) {
            return driveId.zzc == this.zzc;
        }
        if (driveId.zzc == this.zzc) {
            if (driveId.zzb.equals(this.zzb)) {
                return true;
            }
            zza.zzb("DriveId", "Unexpected unequal resourceId for same DriveId object.");
        }
        return false;
    }

    public final String encodeToString() {
        if (this.zzf == null) {
            DriveId driveId = this;
            zzbuh zzbuh2 = new zzbuh();
            new zzbuh().zza = 1;
            zzbuh2.zzb = driveId.zzb == null ? "" : driveId.zzb;
            zzbuh2.zzc = driveId.zzc;
            zzbuh2.zzd = driveId.zzd;
            zzbuh2.zze = driveId.zze;
            String string = Base64.encodeToString((byte[])zzfls.zza((zzfls)zzbuh2), (int)10);
            String string2 = String.valueOf("DriveId:");
            String string3 = String.valueOf(string);
            this.zzf = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        return this.zzf;
    }

    public final String toInvariantString() {
        if (this.zzg == null) {
            DriveId driveId = this;
            zzbui zzbui2 = new zzbui();
            new zzbui().zza = driveId.zzc;
            zzbui2.zzb = driveId.zzd;
            byte[] byArray = zzfls.zza((zzfls)zzbui2);
            this.zzg = Base64.encodeToString((byte[])byArray, (int)10);
        }
        return this.zzg;
    }

    public String toString() {
        return this.encodeToString();
    }

    public static DriveId decodeFromString(String string) {
        String string2 = String.valueOf(string);
        zzbq.zzb((boolean)string.startsWith("DriveId:"), (Object)(string2.length() != 0 ? "Invalid DriveId: ".concat(string2) : new String("Invalid DriveId: ")));
        return DriveId.zza(Base64.decode((String)string.substring(8), (int)10));
    }

    @Hide
    private static DriveId zza(byte[] byArray) {
        zzbuh zzbuh2;
        try {
            byte[] byArray2 = byArray;
            zzbuh2 = (zzbuh)zzfls.zza((zzfls)new zzbuh(), (byte[])byArray2);
        }
        catch (zzflr zzflr2) {
            throw new IllegalArgumentException();
        }
        String string = "".equals(zzbuh2.zzb) ? null : zzbuh2.zzb;
        return new DriveId(string, zzbuh2.zzc, zzbuh2.zzd, zzbuh2.zze);
    }
}

