/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.zzg;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbrr;
import com.google.android.gms.internal.zzbuj;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
extends zzbgl
implements ResourceEvent {
    private static final zzal zza = new zzal("CompletionEvent", "");
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final int STATUS_CANCELED = 3;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new zzg();
    private DriveId zzb;
    private String zzc;
    private ParcelFileDescriptor zzd;
    private ParcelFileDescriptor zze;
    private MetadataBundle zzf;
    private List<String> zzg;
    private int zzh;
    private IBinder zzi;
    private boolean zzj = false;
    private boolean zzk = false;
    private boolean zzl = false;

    @Hide
    CompletionEvent(DriveId driveId, String string, ParcelFileDescriptor parcelFileDescriptor, ParcelFileDescriptor parcelFileDescriptor2, MetadataBundle metadataBundle, List<String> list, int n, IBinder iBinder) {
        this.zzb = driveId;
        this.zzc = string;
        this.zzd = parcelFileDescriptor;
        this.zze = parcelFileDescriptor2;
        this.zzf = metadataBundle;
        this.zzg = list;
        this.zzh = n;
        this.zzi = iBinder;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        int n2 = n | 1;
        Parcel parcel2 = parcel;
        CompletionEvent completionEvent = this;
        int n3 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable)completionEvent.zzb, (int)n2, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (String)completionEvent.zzc, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (Parcelable)completionEvent.zzd, (int)n2, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (Parcelable)completionEvent.zze, (int)n2, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (Parcelable)completionEvent.zzf, (int)n2, (boolean)false);
        zzbgo.zzb((Parcel)parcel2, (int)7, completionEvent.zzg, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (int)completionEvent.zzh);
        zzbgo.zza((Parcel)parcel2, (int)9, (IBinder)completionEvent.zzi, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n3);
    }

    @Override
    @Hide
    public final int zza() {
        return 2;
    }

    @Override
    public final DriveId getDriveId() {
        this.zzb();
        return this.zzb;
    }

    public final String getAccountName() {
        this.zzb();
        return this.zzc;
    }

    public final InputStream getBaseContentsInputStream() {
        this.zzb();
        if (this.zzd == null) {
            return null;
        }
        if (this.zzj) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzj = true;
        return new FileInputStream(this.zzd.getFileDescriptor());
    }

    public final InputStream getModifiedContentsInputStream() {
        this.zzb();
        if (this.zze == null) {
            return null;
        }
        if (this.zzk) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzk = true;
        return new FileInputStream(this.zze.getFileDescriptor());
    }

    public final MetadataChangeSet getModifiedMetadataChangeSet() {
        this.zzb();
        if (this.zzf != null) {
            return new MetadataChangeSet(this.zzf);
        }
        return null;
    }

    public final List<String> getTrackingTags() {
        this.zzb();
        return new ArrayList<String>(this.zzg);
    }

    public final int getStatus() {
        this.zzb();
        return this.zzh;
    }

    public final void dismiss() {
        this.zza(false);
    }

    public final void snooze() {
        this.zza(true);
    }

    private final void zza(boolean bl) {
        this.zzb();
        this.zzl = true;
        zzp.zza((ParcelFileDescriptor)this.zzd);
        zzp.zza((ParcelFileDescriptor)this.zze);
        if (this.zzf != null && this.zzf.zzc(zzbuj.zzaf)) {
            this.zzf.zza(zzbuj.zzaf).zzb();
        }
        if (this.zzi == null) {
            String string = bl ? "snooze" : "dismiss";
            zza.zzc("CompletionEvent", "No callback on %s", new Object[]{string});
            return;
        }
        try {
            zzbrr.zza(this.zzi).zza(bl);
            return;
        }
        catch (RemoteException remoteException) {
            String string = bl ? "snooze" : "dismiss";
            zza.zzc("CompletionEvent", String.format("RemoteException on %s", string), (Throwable)remoteException);
            return;
        }
    }

    private final void zzb() {
        if (this.zzl) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public final String toString() {
        String string;
        if (this.zzg == null) {
            string = "<null>";
        } else {
            String string2 = TextUtils.join((CharSequence)"','", this.zzg);
            string = new StringBuilder(2 + String.valueOf(string2).length()).append("'").append(string2).append("'").toString();
        }
        String string3 = string;
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", new Object[]{this.zzb, this.zzh, string3});
    }
}

