/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveClient;
import com.google.android.gms.drive.DrivePreferencesApi;
import com.google.android.gms.drive.DriveResourceClient;
import com.google.android.gms.drive.zzf;
import com.google.android.gms.drive.zzg;
import com.google.android.gms.drive.zzh;
import com.google.android.gms.drive.zzk;
import com.google.android.gms.drive.zzm;
import com.google.android.gms.internal.zzbmu;
import com.google.android.gms.internal.zzbnq;
import com.google.android.gms.internal.zzbnv;
import com.google.android.gms.internal.zzboj;
import com.google.android.gms.internal.zzbot;
import com.google.android.gms.internal.zzboz;
import com.google.android.gms.internal.zzbqx;
import java.util.Arrays;
import java.util.Set;

public final class Drive {
    @Hide
    public static final Api.zzf<zzbnq> zzegu = new Api.zzf();
    @Hide
    private static final Api.zza<zzbnq, Api.ApiOptions.NoOptions> zzegv = new zzf();
    @Hide
    private static final Api.zza<zzbnq, zzb> zzgpj = new zzg();
    @Hide
    private static final Api.zza<zzbnq, zza> zzgpk = new zzh();
    public static final Scope SCOPE_FILE = new Scope("https://www.googleapis.com/auth/drive.file");
    public static final Scope SCOPE_APPFOLDER = new Scope("https://www.googleapis.com/auth/drive.appdata");
    @Hide
    private static Scope zzgpl = new Scope("https://www.googleapis.com/auth/drive");
    @Hide
    private static Scope zzgpm = new Scope("https://www.googleapis.com/auth/drive.apps");
    @Deprecated
    public static final Api<Api.ApiOptions.NoOptions> API = new Api("Drive.API", zzegv, zzegu);
    @Hide
    private static Api<zzb> zzgpn = new Api("Drive.INTERNAL_API", zzgpj, zzegu);
    @Hide
    public static final Api<zza> zzgpo = new Api("Drive.API_CONNECTIONLESS", zzgpk, zzegu);
    @Deprecated
    public static final DriveApi DriveApi = new zzbmu();
    @Hide
    private static zzk zzgpp = new zzboj();
    @Hide
    private static zzm zzgpq = new zzbqx();
    @Deprecated
    public static final DrivePreferencesApi DrivePreferencesApi = new zzbot();

    private static void zza(GoogleSignInAccount googleSignInAccount) {
        zzbq.checkNotNull((Object)googleSignInAccount);
        Set set = googleSignInAccount.zzacf();
        zzbq.checkArgument((set.contains(SCOPE_FILE) || set.contains(SCOPE_APPFOLDER) || set.contains(zzgpl) || set.contains(zzgpm) ? 1 : 0) != 0, (Object)"You must request a Drive scope in order to interact with the Drive API.");
    }

    public static DriveClient getDriveClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        Drive.zza(googleSignInAccount);
        return new zzbnv(context, new zza(googleSignInAccount));
    }

    public static DriveClient getDriveClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        Drive.zza(googleSignInAccount);
        return new zzbnv(activity, new zza(googleSignInAccount));
    }

    public static DriveResourceClient getDriveResourceClient(@NonNull Context context, @NonNull GoogleSignInAccount googleSignInAccount) {
        Drive.zza(googleSignInAccount);
        return new zzboz(context, new zza(googleSignInAccount));
    }

    public static DriveResourceClient getDriveResourceClient(@NonNull Activity activity, @NonNull GoogleSignInAccount googleSignInAccount) {
        Drive.zza(googleSignInAccount);
        return new zzboz(activity, new zza(googleSignInAccount));
    }

    private Drive() {
    }

    @Hide
    public static final class zza
    implements Api.ApiOptions.HasGoogleSignInAccountOptions {
        private final Bundle zzgpr = new Bundle();
        private final GoogleSignInAccount zzgps;

        public zza(@NonNull GoogleSignInAccount googleSignInAccount) {
            this.zzgps = googleSignInAccount;
        }

        public final Bundle zzapj() {
            return this.zzgpr;
        }

        public final GoogleSignInAccount getGoogleSignInAccount() {
            return this.zzgps;
        }

        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            zza zza2 = (zza)object;
            if (!zzbg.equal((Object)this.zzgps, (Object)zza2.getGoogleSignInAccount())) {
                return false;
            }
            String string = this.zzgpr.getString("method_trace_filename");
            String string2 = zza2.zzgpr.getString("method_trace_filename");
            return (string == null && string2 == null || string != null && string2 != null && string.equals(string2)) && this.zzgpr.getBoolean("bypass_initial_sync") == zza2.zzgpr.getBoolean("bypass_initial_sync") && this.zzgpr.getInt("proxy_type") == zza2.zzgpr.getInt("proxy_type");
        }

        public final int hashCode() {
            String string = this.zzgpr.getString("method_trace_filename", "");
            int n = this.zzgpr.getInt("proxy_type");
            boolean bl = this.zzgpr.getBoolean("bypass_initial_sync");
            return Arrays.hashCode(new Object[]{this.zzgps, string, n, bl});
        }
    }

    @Hide
    public static final class zzb
    implements Api.ApiOptions.Optional {
    }
}

