/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.zzl;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbof;
import com.google.android.gms.internal.zzbok;
import com.google.android.gms.internal.zzbql;
import com.google.android.gms.internal.zzbuh;
import com.google.android.gms.internal.zzbui;
import com.google.android.gms.internal.zzflr;
import com.google.android.gms.internal.zzfls;

public class DriveId
extends zzbgl
implements ReflectedParcelable {
    private static final zzal zzgpv = new zzal("DriveId", "");
    public static final int RESOURCE_TYPE_UNKNOWN = -1;
    public static final int RESOURCE_TYPE_FILE = 0;
    public static final int RESOURCE_TYPE_FOLDER = 1;
    public static final Parcelable.Creator<DriveId> CREATOR = new zzl();
    private String zzgpw;
    private long zzgpx;
    private long zzgoz;
    private int zzgpy;
    private volatile String zzgpb = null;
    private volatile String zzgpz = null;

    @Hide
    public static DriveId zzhe(String string) {
        zzbq.checkNotNull((Object)string);
        return new DriveId(string, -1L, -1L, -1);
    }

    public String getResourceId() {
        return this.zzgpw;
    }

    public int getResourceType() {
        return this.zzgpy;
    }

    public DriveFile asDriveFile() {
        if (this.zzgpy == 1) {
            throw new IllegalStateException("This DriveId corresponds to a folder. Call asDriveFolder instead.");
        }
        return new zzbof(this);
    }

    public DriveFolder asDriveFolder() {
        if (this.zzgpy == 0) {
            throw new IllegalStateException("This DriveId corresponds to a file. Call asDriveFile instead.");
        }
        return new zzbok(this);
    }

    public DriveResource asDriveResource() {
        if (this.zzgpy == 1) {
            return this.asDriveFolder();
        }
        if (this.zzgpy == 0) {
            return this.asDriveFile();
        }
        return new zzbql(this);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DriveId driveId = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)driveId.zzgpw, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (long)driveId.zzgpx);
        zzbgo.zza((Parcel)parcel2, (int)4, (long)driveId.zzgoz);
        zzbgo.zzc((Parcel)parcel2, (int)5, (int)driveId.zzgpy);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    @Hide
    public DriveId(String string, long l, long l2, int n) {
        this.zzgpw = string;
        zzbq.checkArgument((!"".equals(string) ? 1 : 0) != 0);
        zzbq.checkArgument((string != null || l != -1L ? 1 : 0) != 0);
        this.zzgpx = l;
        this.zzgoz = l2;
        this.zzgpy = n;
    }

    public int hashCode() {
        if (this.zzgpx == -1L) {
            return this.zzgpw.hashCode();
        }
        String string = String.valueOf(String.valueOf(this.zzgoz));
        String string2 = String.valueOf(String.valueOf(this.zzgpx));
        return (string2.length() != 0 ? string.concat(string2) : new String(string)).hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != DriveId.class) {
            return false;
        }
        DriveId driveId = (DriveId)((Object)object);
        if (driveId.zzgoz != this.zzgoz) {
            return false;
        }
        if (driveId.zzgpx == -1L && this.zzgpx == -1L) {
            return driveId.zzgpw.equals(this.zzgpw);
        }
        if (this.zzgpw == null || driveId.zzgpw == null) {
            return driveId.zzgpx == this.zzgpx;
        }
        if (driveId.zzgpx == this.zzgpx) {
            if (driveId.zzgpw.equals(this.zzgpw)) {
                return true;
            }
            zzgpv.zzv("DriveId", "Unexpected unequal resourceId for same DriveId object.");
        }
        return false;
    }

    public final String encodeToString() {
        if (this.zzgpb == null) {
            DriveId driveId = this;
            zzbuh zzbuh2 = new zzbuh();
            new zzbuh().versionCode = 1;
            zzbuh2.zzgyf = driveId.zzgpw == null ? "" : driveId.zzgpw;
            zzbuh2.zzgyg = driveId.zzgpx;
            zzbuh2.zzgyd = driveId.zzgoz;
            zzbuh2.zzgyh = driveId.zzgpy;
            String string = Base64.encodeToString((byte[])zzfls.zzc((zzfls)zzbuh2), (int)10);
            String string2 = String.valueOf("DriveId:");
            String string3 = String.valueOf(string);
            this.zzgpb = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        return this.zzgpb;
    }

    public final String toInvariantString() {
        if (this.zzgpz == null) {
            DriveId driveId = this;
            zzbui zzbui2 = new zzbui();
            new zzbui().zzgyg = driveId.zzgpx;
            zzbui2.zzgyd = driveId.zzgoz;
            byte[] byArray = zzfls.zzc((zzfls)zzbui2);
            this.zzgpz = Base64.encodeToString((byte[])byArray, (int)10);
        }
        return this.zzgpz;
    }

    public String toString() {
        return this.encodeToString();
    }

    public static DriveId decodeFromString(String string) {
        String string2 = String.valueOf(string);
        zzbq.checkArgument((boolean)string.startsWith("DriveId:"), (Object)(string2.length() != 0 ? "Invalid DriveId: ".concat(string2) : new String("Invalid DriveId: ")));
        return DriveId.zzo(Base64.decode((String)string.substring(8), (int)10));
    }

    @Hide
    private static DriveId zzo(byte[] byArray) {
        zzbuh zzbuh2;
        try {
            byte[] byArray2 = byArray;
            zzbuh2 = (zzbuh)zzfls.zza((zzfls)new zzbuh(), (byte[])byArray2);
        }
        catch (zzflr zzflr2) {
            throw new IllegalArgumentException();
        }
        String string = "".equals(zzbuh2.zzgyf) ? null : zzbuh2.zzgyf;
        return new DriveId(string, zzbuh2.zzgyg, zzbuh2.zzgyd, zzbuh2.zzgyh);
    }
}

