/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.text.TextUtils;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.internal.zzbnq;
import java.util.Arrays;

public class ExecutionOptions {
    public static final int MAX_TRACKING_TAG_STRING_LENGTH = 65536;
    public static final int CONFLICT_STRATEGY_OVERWRITE_REMOTE = 0;
    public static final int CONFLICT_STRATEGY_KEEP_REMOTE = 1;
    private final String zzgqg;
    private final boolean zzgqh;
    private final int zzgqi;

    @Hide
    public ExecutionOptions(String string, boolean bl, int n) {
        this.zzgqg = string;
        this.zzgqh = bl;
        this.zzgqi = n;
    }

    @Hide
    public final String zzapo() {
        return this.zzgqg;
    }

    @Hide
    public final boolean zzapp() {
        return this.zzgqh;
    }

    @Hide
    public final int zzapq() {
        return this.zzgqi;
    }

    @Hide
    public static boolean zzcq(int n) {
        switch (n) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    @Hide
    public final void zzf(GoogleApiClient googleApiClient) {
        zzbnq zzbnq2 = (zzbnq)googleApiClient.zza(Drive.zzegu);
        this.zza(zzbnq2);
    }

    @Hide
    public final void zza(zzbnq zzbnq2) {
        if (this.zzgqh && !zzbnq2.zzaqm()) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to be notified on completion");
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ExecutionOptions executionOptions = (ExecutionOptions)object;
        return zzbg.equal((Object)this.zzgqg, (Object)executionOptions.zzgqg) && this.zzgqi == executionOptions.zzgqi && this.zzgqh == executionOptions.zzgqh;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgqg, this.zzgqi, this.zzgqh});
    }

    public static class Builder {
        @Hide
        protected String zzgqg;
        @Hide
        protected boolean zzgqh;
        @Hide
        protected int zzgqi = 0;

        public Builder() {
        }

        public Builder setTrackingTag(String string) {
            String string2 = string;
            if (!(!TextUtils.isEmpty((CharSequence)string2) && string2.length() <= 65536)) {
                throw new IllegalArgumentException(String.format("trackingTag must not be null nor empty, and the length must be <= the maximum length (%s)", 65536));
            }
            this.zzgqg = string;
            return this;
        }

        public Builder setNotifyOnCompletion(boolean bl) {
            this.zzgqh = bl;
            return this;
        }

        public Builder setConflictStrategy(int n) {
            boolean bl;
            switch (n) {
                case 0: 
                case 1: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!bl) {
                throw new IllegalArgumentException(new StringBuilder(53).append("Unrecognized value for conflict strategy: ").append(n).toString());
            }
            this.zzgqi = n;
            return this;
        }

        @Hide
        protected final void zzapr() {
            if (this.zzgqi == 1 && !this.zzgqh) {
                throw new IllegalStateException("Cannot use CONFLICT_STRATEGY_KEEP_REMOTE without requesting completion notifications");
            }
        }

        public ExecutionOptions build() {
            this.zzapr();
            return new ExecutionOptions(this.zzgqg, this.zzgqh, this.zzgqi);
        }
    }
}

