/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.drive.FileUploadPreferences;
import com.google.android.gms.drive.TransferPreferences;
import java.util.Arrays;

public class TransferPreferencesBuilder {
    public static final TransferPreferences DEFAULT_PREFERENCES = new zza(1, true, 256);
    private int zzgre;
    private boolean zzgrf;
    private int zzgrg;

    public TransferPreferencesBuilder() {
        this(DEFAULT_PREFERENCES);
    }

    public TransferPreferencesBuilder(TransferPreferences transferPreferences) {
        this.zzgre = transferPreferences.getNetworkPreference();
        this.zzgrf = transferPreferences.isRoamingAllowed();
        this.zzgrg = transferPreferences.getBatteryUsagePreference();
    }

    @Hide
    public TransferPreferencesBuilder(FileUploadPreferences fileUploadPreferences) {
        this.zzgre = fileUploadPreferences.getNetworkTypePreference();
        this.zzgrf = fileUploadPreferences.isRoamingAllowed();
        this.zzgrg = fileUploadPreferences.getBatteryUsagePreference();
    }

    public TransferPreferencesBuilder setNetworkPreference(int n) {
        this.zzgre = n;
        return this;
    }

    public TransferPreferencesBuilder setIsRoamingAllowed(boolean bl) {
        this.zzgrf = bl;
        return this;
    }

    public TransferPreferencesBuilder setBatteryUsagePreference(int n) {
        this.zzgrg = n;
        return this;
    }

    public TransferPreferences build() {
        return new zza(this.zzgre, this.zzgrf, this.zzgrg);
    }

    static final class zza
    implements TransferPreferences {
        private final int zzgre;
        private final boolean zzgrf;
        private final int zzgrg;

        zza(int n, boolean bl, int n2) {
            this.zzgre = n;
            this.zzgrf = bl;
            this.zzgrg = n2;
        }

        @Override
        public final int getNetworkPreference() {
            return this.zzgre;
        }

        @Override
        public final boolean isRoamingAllowed() {
            return this.zzgrf;
        }

        @Override
        public final int getBatteryUsagePreference() {
            return this.zzgrg;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.zzgre, this.zzgrf, this.zzgrg});
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            zza zza2 = (zza)object;
            return zza2.zzgre == this.zzgre && zza2.zzgrf == this.zzgrf && zza2.zzgrg == this.zzgrg;
        }

        public final String toString() {
            return String.format("NetworkPreference: %s, IsRoamingAllowed %s, BatteryUsagePreference %s", this.zzgre, this.zzgrf, this.zzgrg);
        }
    }
}

