/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.metadata.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.zzf;
import com.google.android.gms.drive.metadata.internal.zzj;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbuj;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

@Hide
public final class MetadataBundle
extends zzbgl
implements ReflectedParcelable {
    private static final zzal zzgpv = new zzal("MetadataBundle", "");
    public static final Parcelable.Creator<MetadataBundle> CREATOR = new zzj();
    private Bundle zzgyt;

    @Hide
    MetadataBundle(Bundle bundle) {
        this.zzgyt = (Bundle)zzbq.checkNotNull((Object)bundle);
        this.zzgyt.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.zzgyt.keySet()) {
            if (zzf.zzhg(string) != null) continue;
            arrayList.add(string);
            zzgpv.zzc("MetadataBundle", "Ignored unknown metadata field in bundle: %s", new Object[]{string});
        }
        ArrayList<String> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            String string;
            Object e = arrayList2.get(i);
            string = (String)e;
            this.zzgyt.remove(string);
        }
    }

    public static MetadataBundle zzaqz() {
        return new MetadataBundle(new Bundle());
    }

    public static <T> MetadataBundle zzb(MetadataField<T> metadataField, T t) {
        MetadataBundle metadataBundle = MetadataBundle.zzaqz();
        metadataBundle.zzc(metadataField, t);
        return metadataBundle;
    }

    public final MetadataBundle zzara() {
        return new MetadataBundle(new Bundle(this.zzgyt));
    }

    public final <T> void zzc(MetadataField<T> metadataField, T t) {
        if (zzf.zzhg(metadataField.getName()) == null) {
            String string = String.valueOf(metadataField.getName());
            throw new IllegalArgumentException(string.length() != 0 ? "Unregistered field: ".concat(string) : new String("Unregistered field: "));
        }
        metadataField.zza(t, this.zzgyt);
    }

    public final <T> T zza(MetadataField<T> metadataField) {
        return metadataField.zzn(this.zzgyt);
    }

    public final <T> T zzc(MetadataField<T> metadataField) {
        T t = this.zza(metadataField);
        this.zzgyt.remove(metadataField.getName());
        return t;
    }

    public final boolean zzd(MetadataField<?> metadataField) {
        return this.zzgyt.containsKey(metadataField.getName());
    }

    public final Set<MetadataField<?>> zzarb() {
        HashSet hashSet = new HashSet();
        for (String string : this.zzgyt.keySet()) {
            hashSet.add(zzf.zzhg(string));
        }
        return hashSet;
    }

    public final void setContext(Context context) {
        BitmapTeleporter bitmapTeleporter = this.zza(zzbuj.zzhac);
        if (bitmapTeleporter != null) {
            bitmapTeleporter.setTempDir(context.getCacheDir());
        }
    }

    public final int hashCode() {
        int n = 1;
        for (String string : this.zzgyt.keySet()) {
            n = n * 31 + this.zzgyt.get(string).hashCode();
        }
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        MetadataBundle metadataBundle = (MetadataBundle)((Object)object);
        Set set = this.zzgyt.keySet();
        if (!set.equals(metadataBundle.zzgyt.keySet())) {
            return false;
        }
        for (String string : set) {
            if (zzbg.equal((Object)this.zzgyt.get(string), (Object)metadataBundle.zzgyt.get(string))) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        String string = String.valueOf(this.zzgyt);
        return new StringBuilder(24 + String.valueOf(string).length()).append("MetadataBundle [values=").append(string).append("]").toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        MetadataBundle metadataBundle = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Bundle)metadataBundle.zzgyt, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }
}

