/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.ParcelFileDescriptor;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.zzc;
import com.google.android.gms.drive.zzr;
import com.google.android.gms.drive.zzt;
import com.google.android.gms.internal.zzbob;
import com.google.android.gms.internal.zzboc;
import com.google.android.gms.internal.zzbod;
import com.google.android.gms.internal.zzboe;
import java.io.InputStream;
import java.io.OutputStream;

@Hide
public final class zzboa
implements DriveContents {
    private static final zzal zzgpv = new zzal("DriveContentsImpl", "");
    private final zzc zzgul;
    private boolean mClosed = false;
    private boolean zzgum = false;
    private boolean zzgun = false;

    public zzboa(zzc zzc2) {
        this.zzgul = (zzc)((Object)zzbq.checkNotNull((Object)((Object)zzc2)));
    }

    @Override
    public final DriveId getDriveId() {
        return this.zzgul.getDriveId();
    }

    @Override
    public final int getMode() {
        return this.zzgul.getMode();
    }

    @Override
    public final ParcelFileDescriptor getParcelFileDescriptor() {
        if (this.mClosed) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        return this.zzgul.getParcelFileDescriptor();
    }

    @Override
    public final InputStream getInputStream() {
        if (this.mClosed) {
            throw new IllegalStateException("Contents have been closed, cannot access the input stream.");
        }
        if (this.zzgul.getMode() != 0x10000000) {
            throw new IllegalStateException("getInputStream() can only be used with contents opened with MODE_READ_ONLY.");
        }
        if (this.zzgum) {
            throw new IllegalStateException("getInputStream() can only be called once per Contents instance.");
        }
        this.zzgum = true;
        return this.zzgul.getInputStream();
    }

    @Override
    public final OutputStream getOutputStream() {
        if (this.mClosed) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        if (this.zzgul.getMode() != 0x20000000) {
            throw new IllegalStateException("getOutputStream() can only be used with contents opened with MODE_WRITE_ONLY.");
        }
        if (this.zzgun) {
            throw new IllegalStateException("getOutputStream() can only be called once per Contents instance.");
        }
        this.zzgun = true;
        return this.zzgul.getOutputStream();
    }

    @Override
    public final PendingResult<DriveApi.DriveContentsResult> reopenForWrite(GoogleApiClient googleApiClient) {
        if (this.mClosed) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.zzgul.getMode() != 0x10000000) {
            throw new IllegalStateException("reopenForWrite can only be used with DriveContents opened with MODE_READ_ONLY.");
        }
        this.zzapm();
        return googleApiClient.zzd((zzm)new zzbob(this, googleApiClient));
    }

    @Override
    public final PendingResult<Status> commit(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet) {
        return this.zza(googleApiClient, metadataChangeSet, null);
    }

    @Override
    public final PendingResult<Status> commit(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, ExecutionOptions executionOptions) {
        return this.zza(googleApiClient, metadataChangeSet, executionOptions == null ? null : zzr.zzb(executionOptions));
    }

    private final PendingResult<Status> zza(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, zzr zzr2) {
        if (zzr2 == null) {
            zzr2 = (zzr)((ExecutionOptions.Builder)new zzt()).build();
        }
        if (this.zzgul.getMode() == 0x10000000) {
            throw new IllegalStateException("Cannot commit contents opened with MODE_READ_ONLY");
        }
        if (ExecutionOptions.zzcq(zzr2.zzapq()) && !this.zzgul.zzapd()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        zzr2.zzf(googleApiClient);
        if (this.mClosed) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.getDriveId() == null) {
            throw new IllegalStateException("Only DriveContents obtained through DriveFile.open can be committed.");
        }
        MetadataChangeSet metadataChangeSet2 = metadataChangeSet != null ? metadataChangeSet : MetadataChangeSet.zzgqo;
        zzr zzr3 = zzr2;
        this.zzapm();
        return googleApiClient.zze((zzm)new zzboc(this, googleApiClient, metadataChangeSet2, zzr3));
    }

    @Override
    public final void discard(GoogleApiClient googleApiClient) {
        if (this.mClosed) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        this.zzapm();
        ((zzboe)googleApiClient.zze((zzm)new zzboe(this, googleApiClient))).setResultCallback(new zzbod(this));
    }

    @Override
    public final zzc zzapl() {
        return this.zzgul;
    }

    @Override
    public final void zzapm() {
        zzp.zza((ParcelFileDescriptor)this.zzgul.getParcelFileDescriptor());
        this.mClosed = true;
    }

    @Override
    public final boolean zzapn() {
        return this.mClosed;
    }

    static /* synthetic */ zzc zza(zzboa zzboa2) {
        return zzboa2.zzgul;
    }

    static /* synthetic */ zzal zzaqn() {
        return zzgpv;
    }
}

