/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.content.IntentSender;
import android.os.ParcelFileDescriptor;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.zzj;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.internal.zzhy;

public class CreateFileActivityBuilder {
    public static final String EXTRA_RESPONSE_DRIVE_ID = "response_drive_id";
    private final zzj zzVN = new zzj(0);
    private DriveContents zzVO;
    private boolean zzVP;

    public CreateFileActivityBuilder setInitialDriveContents(DriveContents driveContents) {
        if (driveContents != null) {
            if (!(driveContents instanceof zzt)) {
                throw new IllegalArgumentException("Only DriveContents obtained from the Drive API are accepted.");
            }
            if (driveContents.getDriveId() != null) {
                throw new IllegalArgumentException("Only DriveContents obtained through DriveApi.newDriveContents are accepted for file creation.");
            }
            if (driveContents.zznt()) {
                throw new IllegalArgumentException("DriveContents are already closed.");
            }
            this.zzVN.zzbO(driveContents.zznr().getRequestId());
            this.zzVO = driveContents;
        } else {
            this.zzVN.zzbO(1);
        }
        this.zzVP = true;
        return this;
    }

    public CreateFileActivityBuilder setInitialMetadata(MetadataChangeSet metadataChangeSet) {
        this.zzVN.zza(metadataChangeSet);
        return this;
    }

    public CreateFileActivityBuilder setActivityStartFolder(DriveId folder) {
        this.zzVN.zza(folder);
        return this;
    }

    public CreateFileActivityBuilder setActivityTitle(String title) {
        this.zzVN.zzcc(title);
        return this;
    }

    public IntentSender build(GoogleApiClient apiClient) {
        zzv.zzb((Object)this.zzVP, (Object)"Must call setInitialDriveContents to CreateFileActivityBuilder.");
        zzv.zza((boolean)apiClient.isConnected(), (Object)"Client must be connected");
        zzv.zzb((apiClient.zza(Drive.SCOPE_FILE) || apiClient.zza(Drive.zzVQ) ? 1 : 0) != 0, (Object)"The apiClient must have suitable scope to create files");
        if (this.zzVO != null) {
            zzhy.zza((ParcelFileDescriptor)this.zzVO.getParcelFileDescriptor());
            this.zzVO.zzns();
        }
        return this.zzVN.build(apiClient);
    }
}

