/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.drive.internal.zzar;
import com.google.android.gms.drive.internal.zzas;
import com.google.android.gms.drive.internal.zzx;
import com.google.android.gms.drive.zzd;
import com.google.android.gms.internal.zznx;
import com.google.android.gms.internal.zzny;

public class DriveId
implements SafeParcelable {
    public static final int RESOURCE_TYPE_UNKNOWN = -1;
    public static final int RESOURCE_TYPE_FILE = 0;
    public static final int RESOURCE_TYPE_FOLDER = 1;
    public static final Parcelable.Creator<DriveId> CREATOR = new zzd();
    final int zzzH;
    final String zzVV;
    final long zzVW;
    final long zzVG;
    final int zzVX;
    private volatile String zzVI = null;
    private volatile String zzVY = null;

    public static DriveId zzbZ(String string) {
        zzv.zzr((Object)string);
        return new DriveId(string, -1L, -1L, -1);
    }

    public String getResourceId() {
        return this.zzVV;
    }

    public int getResourceType() {
        return this.zzVX;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzd.zza(this, out, flags);
    }

    DriveId(int versionCode, String resourceId, long sqlId, long databaseInstanceId, int resourceType) {
        this.zzzH = versionCode;
        this.zzVV = resourceId;
        zzv.zzQ((!"".equals(resourceId) ? 1 : 0) != 0);
        zzv.zzQ((resourceId != null || sqlId != -1L ? 1 : 0) != 0);
        this.zzVW = sqlId;
        this.zzVG = databaseInstanceId;
        this.zzVX = resourceType;
    }

    public DriveId(String resourceId, long sqlId, long databaseInstanceId, int resourceType) {
        this(1, (String)(resourceId != null && resourceId.startsWith("generated-android-") ? null : resourceId), sqlId, databaseInstanceId, resourceType);
    }

    public int hashCode() {
        if (this.zzVW == -1L) {
            return this.zzVV.hashCode();
        }
        return (String.valueOf(this.zzVG) + String.valueOf(this.zzVW)).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DriveId)) {
            return false;
        }
        DriveId driveId = (DriveId)obj;
        if (driveId.zzVG != this.zzVG) {
            zzx.zzt("DriveId", "Attempt to compare invalid DriveId detected. Has local storage been cleared?");
            return false;
        }
        if (driveId.zzVW == -1L && this.zzVW == -1L) {
            return driveId.zzVV.equals(this.zzVV);
        }
        if (this.zzVV == null || driveId.zzVV == null) {
            return driveId.zzVW == this.zzVW;
        }
        if (driveId.zzVW == this.zzVW) {
            if (driveId.zzVV.equals(this.zzVV)) {
                return true;
            }
            zzx.zzt("DriveId", "Unexpected unequal resourceId for same DriveId object.");
        }
        return false;
    }

    public final String encodeToString() {
        if (this.zzVI == null) {
            byte[] byArray = this.zzno();
            String string = Base64.encodeToString((byte[])byArray, (int)10);
            this.zzVI = "DriveId:" + string;
        }
        return this.zzVI;
    }

    public final String toInvariantString() {
        if (this.zzVY == null) {
            byte[] byArray = this.zznu();
            this.zzVY = Base64.encodeToString((byte[])byArray, (int)10);
        }
        return this.zzVY;
    }

    final byte[] zzno() {
        zzar zzar2 = new zzar();
        zzar2.versionCode = this.zzzH;
        zzar2.zzYT = this.zzVV == null ? "" : this.zzVV;
        zzar2.zzYU = this.zzVW;
        zzar2.zzYR = this.zzVG;
        zzar2.zzYV = this.zzVX;
        byte[] byArray = zzny.zzf((zzny)zzar2);
        return byArray;
    }

    private byte[] zznu() {
        zzas zzas2 = new zzas();
        zzas2.zzYU = this.zzVW;
        zzas2.zzYR = this.zzVG;
        byte[] byArray = zzny.zzf((zzny)zzas2);
        return byArray;
    }

    public String toString() {
        return this.encodeToString();
    }

    public static DriveId decodeFromString(String s) {
        zzv.zzb((boolean)s.startsWith("DriveId:"), (Object)("Invalid DriveId: " + s));
        String string = s.substring("DriveId:".length());
        byte[] byArray = Base64.decode((String)string, (int)10);
        return DriveId.zzi(byArray);
    }

    static DriveId zzi(byte[] byArray) {
        zzar zzar2;
        try {
            zzar2 = zzar.zzj(byArray);
        }
        catch (zznx zznx2) {
            throw new IllegalArgumentException();
        }
        String string = "".equals(zzar2.zzYT) ? null : zzar2.zzYT;
        DriveId driveId = new DriveId(zzar2.versionCode, string, zzar2.zzYU, zzar2.zzYR, zzar2.zzYV);
        return driveId;
    }
}

