/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.internal.zzs;

public final class ExecutionOptions {
    public static final int MAX_TRACKING_TAG_STRING_LENGTH = 65536;
    public static final int CONFLICT_STRATEGY_OVERWRITE_REMOTE = 0;
    public static final int CONFLICT_STRATEGY_KEEP_REMOTE = 1;
    private final String zzWf;
    private final boolean zzWg;
    private final int zzWh;

    public ExecutionOptions(String trackingTag, boolean notifyOnCompletion, int conflictStrategy) {
        this.zzWf = trackingTag;
        this.zzWg = notifyOnCompletion;
        this.zzWh = conflictStrategy;
    }

    public String zznv() {
        return this.zzWf;
    }

    public boolean zznw() {
        return this.zzWg;
    }

    public int zznx() {
        return this.zzWh;
    }

    public static boolean zzbr(int n) {
        switch (n) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean zzbs(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean zzca(String string) {
        return string != null && !string.isEmpty() && string.length() <= 65536;
    }

    public static void zza(GoogleApiClient googleApiClient, ExecutionOptions executionOptions) {
        zzs zzs2 = (zzs)googleApiClient.zza(Drive.zzKh);
        if (executionOptions.zznw() && !zzs2.zznR()) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to be notified on completion");
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ExecutionOptions executionOptions = (ExecutionOptions)o;
        return zzu.equal((Object)this.zzWf, (Object)executionOptions.zzWf) && this.zzWh == executionOptions.zzWh && this.zzWg == executionOptions.zzWg;
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzWf, this.zzWh, this.zzWg});
    }

    public static final class Builder {
        private String zzWf;
        private boolean zzWg;
        private int zzWh = 0;

        public Builder setTrackingTag(String trackingTag) {
            if (!ExecutionOptions.zzca(trackingTag)) {
                throw new IllegalArgumentException(String.format("trackingTag must not be null nor empty, and the length must be <= the maximum length (%s)", 65536));
            }
            this.zzWf = trackingTag;
            return this;
        }

        public Builder setNotifyOnCompletion(boolean notify) {
            this.zzWg = notify;
            return this;
        }

        public Builder setConflictStrategy(int strategy) {
            if (!ExecutionOptions.zzbs(strategy)) {
                throw new IllegalArgumentException("Unrecognized value for conflict strategy: " + strategy);
            }
            this.zzWh = strategy;
            return this;
        }

        public ExecutionOptions build() {
            if (this.zzWh == 1 && !this.zzWg) {
                throw new IllegalStateException("Cannot use CONFLICT_STRATEGY_KEEP_REMOTE without requesting completion notifications");
            }
            return new ExecutionOptions(this.zzWf, this.zzWg, this.zzWh);
        }
    }
}

