/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.ChangesAvailableOptions;
import com.google.android.gms.drive.events.zzc;
import com.google.android.gms.drive.events.zzg;
import com.google.android.gms.drive.internal.AddEventListenerRequest;
import com.google.android.gms.drive.internal.CancelPendingActionsRequest;
import com.google.android.gms.drive.internal.DisconnectRequest;
import com.google.android.gms.drive.internal.RemoveEventListenerRequest;
import com.google.android.gms.drive.internal.zzac;
import com.google.android.gms.drive.internal.zzak;
import com.google.android.gms.drive.internal.zzal;
import com.google.android.gms.drive.internal.zzam;
import com.google.android.gms.drive.internal.zzbr;
import com.google.android.gms.drive.internal.zzq;
import com.google.android.gms.drive.internal.zzr;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class zzs
extends zzi<zzak> {
    private final String zzPC;
    private final Bundle zzXI;
    private final boolean zzXJ;
    private DriveId zzXK;
    private DriveId zzXL;
    final GoogleApiClient.ConnectionCallbacks zzXM;
    final Map<DriveId, Map<ChangeListener, zzac>> zzXN = new HashMap<DriveId, Map<ChangeListener, zzac>>();
    final Map<zzc, zzac> zzXO = new HashMap<zzc, zzac>();
    final Map<DriveId, Map<com.google.android.gms.drive.events.zzi, zzac>> zzXP = new HashMap<DriveId, Map<com.google.android.gms.drive.events.zzi, zzac>>();

    public zzs(Context context, Looper looper, zze zze2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, Bundle bundle) {
        super(context, looper, 11, connectionCallbacks, onConnectionFailedListener, zze2);
        this.zzPC = zze2.zzlJ();
        this.zzXM = connectionCallbacks;
        this.zzXI = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.zzXJ = false;
                break;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    throw new IllegalStateException("Drive event service " + serviceInfo.name + " must be exported in AndroidManifest.xml");
                }
                this.zzXJ = true;
                break;
            }
            default: {
                throw new IllegalStateException("AndroidManifest.xml can only define one service that handles the " + intent.getAction() + " action");
            }
        }
    }

    public boolean zzjM() {
        return true;
    }

    protected zzak zzaa(IBinder iBinder) {
        return zzak.zza.zzab(iBinder);
    }

    protected String zzer() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    protected Bundle zzka() {
        String string = this.getContext().getPackageName();
        zzv.zzr((Object)string);
        zzv.zzP((!this.zzlU().zzlH().isEmpty() ? 1 : 0) != 0);
        Bundle bundle = new Bundle();
        if (!string.equals(this.zzPC)) {
            bundle.putString("proxy_package_name", this.zzPC);
        }
        bundle.putAll(this.zzXI);
        return bundle;
    }

    protected String zzeq() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public zzak zznO() throws DeadObjectException {
        return (zzak)this.zzlX();
    }

    public DriveId zznP() {
        return this.zzXK;
    }

    public DriveId zznQ() {
        return this.zzXL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Map<Object, Object> map;
        if (this.isConnected()) {
            try {
                map = (zzak)this.zzlX();
                map.zza(new DisconnectRequest());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        super.disconnect();
        map = this.zzXN;
        synchronized (map) {
            this.zzXN.clear();
        }
        map = this.zzXO;
        synchronized (map) {
            this.zzXO.clear();
        }
        map = this.zzXP;
        synchronized (map) {
            this.zzXP.clear();
        }
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.zzXK = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.zzXL = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
        }
        super.zza(n, iBinder, bundle);
    }

    public boolean zznR() {
        return this.zzXJ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        int n = 1;
        zzv.zzb((boolean)zzg.zza(n, driveId), (Object)"id");
        zzv.zzb((Object)changeListener, (Object)"listener");
        zzv.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        Map<DriveId, Map<ChangeListener, zzac>> map = this.zzXN;
        synchronized (map) {
            zzac zzac2;
            Map<ChangeListener, zzac> map2 = this.zzXN.get(driveId);
            if (map2 == null) {
                map2 = new HashMap<ChangeListener, zzac>();
                this.zzXN.put(driveId, map2);
            }
            if ((zzac2 = map2.get(changeListener)) == null) {
                zzac2 = new zzac(this.getLooper(), this.getContext(), n, changeListener);
                map2.put(changeListener, zzac2);
            } else if (zzac2.zzbW(n)) {
                return new zzq.zzj(googleApiClient, Status.zzQU);
            }
            zzac2.zzbV(n);
            return this.zza(googleApiClient, n, driveId, zzac2, null);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId, final zzac zzac2, final ChangesAvailableOptions changesAvailableOptions) {
        return googleApiClient.zzb((zza.zza)new zzr.zza(googleApiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zznO().zza(new AddEventListenerRequest(driveId, n, changesAvailableOptions), (zzam)zzac2, null, (zzal)new zzbr((zza.zzb<Status>)this));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        int n = 1;
        zzv.zzb((boolean)zzg.zza(n, driveId), (Object)"id");
        zzv.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        zzv.zzb((Object)changeListener, (Object)"listener");
        Map<DriveId, Map<ChangeListener, zzac>> map = this.zzXN;
        synchronized (map) {
            Map<ChangeListener, zzac> map2 = this.zzXN.get(driveId);
            if (map2 == null) {
                return new zzq.zzj(googleApiClient, Status.zzQU);
            }
            zzac zzac2 = map2.remove(changeListener);
            if (zzac2 == null) {
                return new zzq.zzj(googleApiClient, Status.zzQU);
            }
            if (map2.isEmpty()) {
                this.zzXN.remove(driveId);
            }
            return this.zza(googleApiClient, n, driveId, zzac2);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId, final zzac zzac2) {
        return googleApiClient.zzb((zza.zza)new zzr.zza(googleApiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zznO().zza(new RemoveEventListenerRequest(driveId, n), (zzam)zzac2, null, (zzal)new zzbr((zza.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, 1, driveId, (ChangesAvailableOptions)null);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId, final ChangesAvailableOptions changesAvailableOptions) {
        zzv.zzb((boolean)zzg.zza(n, driveId), (Object)"id");
        zzv.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        if (!this.zzXJ) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient.zzb((zza.zza)new zzr.zza(googleApiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zznO().zza(new AddEventListenerRequest(driveId, n, changesAvailableOptions), null, null, (zzal)new zzbr((zza.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, 1, driveId);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId) {
        zzv.zzb((boolean)zzg.zza(n, driveId), (Object)"id");
        zzv.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        return googleApiClient.zzb((zza.zza)new zzr.zza(googleApiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zznO().zza(new RemoveEventListenerRequest(driveId, n), null, null, (zzal)new zzbr((zza.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> cancelPendingActions(GoogleApiClient apiClient, final List<String> pendingTags) {
        zzv.zzQ((pendingTags != null ? 1 : 0) != 0);
        zzv.zzQ((!pendingTags.isEmpty() ? 1 : 0) != 0);
        zzv.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        return apiClient.zzb((zza.zza)new zzr.zza(apiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zznO().zza(new CancelPendingActionsRequest(pendingTags), (zzal)new zzbr((zza.zzb<Status>)this));
            }
        });
    }

    protected /* synthetic */ IInterface zzD(IBinder iBinder) {
        return this.zzaa(iBinder);
    }
}

