/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CloseContentsAndUpdateMetadataRequest;
import com.google.android.gms.drive.internal.CloseContentsRequest;
import com.google.android.gms.drive.internal.OpenContentsRequest;
import com.google.android.gms.drive.internal.zzal;
import com.google.android.gms.drive.internal.zzbj;
import com.google.android.gms.drive.internal.zzbr;
import com.google.android.gms.drive.internal.zzq;
import com.google.android.gms.drive.internal.zzr;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzx;
import java.io.InputStream;
import java.io.OutputStream;

public class zzt
implements DriveContents {
    private final Contents zzXW;
    private boolean mClosed = false;
    private boolean zzXX = false;
    private boolean zzXY = false;

    public zzt(Contents contents) {
        this.zzXW = (Contents)zzv.zzr((Object)contents);
    }

    @Override
    public DriveId getDriveId() {
        return this.zzXW.getDriveId();
    }

    @Override
    public int getMode() {
        return this.zzXW.getMode();
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() {
        if (this.zznt()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        return this.zzXW.getParcelFileDescriptor();
    }

    @Override
    public InputStream getInputStream() {
        if (this.zznt()) {
            throw new IllegalStateException("Contents have been closed, cannot access the input stream.");
        }
        if (this.zzXW.getMode() != 0x10000000) {
            throw new IllegalStateException("getInputStream() can only be used with contents opened with MODE_READ_ONLY.");
        }
        if (this.zzXX) {
            throw new IllegalStateException("getInputStream() can only be called once per Contents instance.");
        }
        this.zzXX = true;
        return this.zzXW.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.zznt()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        if (this.zzXW.getMode() != 0x20000000) {
            throw new IllegalStateException("getOutputStream() can only be used with contents opened with MODE_WRITE_ONLY.");
        }
        if (this.zzXY) {
            throw new IllegalStateException("getOutputStream() can only be called once per Contents instance.");
        }
        this.zzXY = true;
        return this.zzXW.getOutputStream();
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> reopenForWrite(GoogleApiClient apiClient) {
        if (this.zznt()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.zzXW.getMode() != 0x10000000) {
            throw new IllegalStateException("reopenForWrite can only be used with DriveContents opened with MODE_READ_ONLY.");
        }
        this.zzns();
        return apiClient.zza((zza.zza)new zzq.zzb(apiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zznO().zza(new OpenContentsRequest(zzt.this.getDriveId(), 0x20000000, zzt.this.zzXW.getRequestId()), (zzal)new zzbj((zza.zzb<DriveApi.DriveContentsResult>)this, null));
            }
        });
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient apiClient, MetadataChangeSet changeSet) {
        return this.commit(apiClient, changeSet, null);
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient apiClient, MetadataChangeSet changeSet, ExecutionOptions executionOptions) {
        if (executionOptions == null) {
            executionOptions = new ExecutionOptions.Builder().build();
        }
        if (this.zzXW.getMode() == 0x10000000) {
            throw new IllegalStateException("Cannot commit contents opened with MODE_READ_ONLY");
        }
        if (ExecutionOptions.zzbr(executionOptions.zznx()) && !this.zzXW.zznp()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        ExecutionOptions.zza(apiClient, executionOptions);
        if (this.zznt()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.getDriveId() == null) {
            throw new IllegalStateException("Only DriveContents obtained through DriveFile.open can be committed.");
        }
        final MetadataChangeSet metadataChangeSet = changeSet != null ? changeSet : MetadataChangeSet.zzWk;
        final ExecutionOptions executionOptions2 = executionOptions;
        this.zzns();
        return apiClient.zzb((zza.zza)new zzr.zza(apiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                metadataChangeSet.zznz().setContext(zzs2.getContext());
                zzs2.zznO().zza(new CloseContentsAndUpdateMetadataRequest(zzt.this.zzXW.getDriveId(), metadataChangeSet.zznz(), zzt.this.zzXW, executionOptions2), (zzal)new zzbr((zza.zzb<Status>)this));
            }
        });
    }

    @Override
    public void discard(GoogleApiClient apiClient) {
        if (this.zznt()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        this.zzns();
        (apiClient.zzb((zza.zza)new zzr.zza(apiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zznO().zza(new CloseContentsRequest(zzt.this.zzXW, false), (zzal)new zzbr((zza.zzb<Status>)this));
            }
        })).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void zzi(Status status) {
                if (!status.isSuccess()) {
                    zzx.zzu("DriveContentsImpl", "Error discarding contents");
                } else {
                    zzx.zzs("DriveContentsImpl", "Contents discarded");
                }
            }

            public /* synthetic */ void onResult(Result x0) {
                this.zzi((Status)x0);
            }
        });
    }

    @Override
    public Contents zznr() {
        return this.zzXW;
    }

    @Override
    public void zzns() {
        this.mClosed = true;
    }

    @Override
    public boolean zznt() {
        return this.mClosed;
    }
}

