/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.Metadata;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.ListParentsRequest;
import com.google.android.gms.drive.internal.OnListParentsResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.SetResourceParentsRequest;
import com.google.android.gms.drive.internal.TrashResourceRequest;
import com.google.android.gms.drive.internal.UntrashResourceRequest;
import com.google.android.gms.drive.internal.UpdateMetadataRequest;
import com.google.android.gms.drive.internal.zzal;
import com.google.android.gms.drive.internal.zzbr;
import com.google.android.gms.drive.internal.zzn;
import com.google.android.gms.drive.internal.zzq;
import com.google.android.gms.drive.internal.zzr;
import com.google.android.gms.drive.internal.zzs;
import java.util.ArrayList;
import java.util.Set;

public class zzz
implements DriveResource {
    protected final DriveId zzVL;

    protected zzz(DriveId driveId) {
        this.zzVL = driveId;
    }

    @Override
    public DriveId getDriveId() {
        return this.zzVL;
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> getMetadata(GoogleApiClient apiClient) {
        return this.zza(apiClient, false);
    }

    private PendingResult<DriveResource.MetadataResult> zza(GoogleApiClient googleApiClient, final boolean bl) {
        return googleApiClient.zza((zza.zza)new zzd(googleApiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zznO().zza(new GetMetadataRequest(zzz.this.zzVL, bl), (zzal)new zzb((zza.zzb<DriveResource.MetadataResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listParents(GoogleApiClient apiClient) {
        return apiClient.zza((zza.zza)new zzq.zzg(apiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zznO().zza(new ListParentsRequest(zzz.this.zzVL), (zzal)new zza((zza.zzb<DriveApi.MetadataBufferResult>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> setParents(GoogleApiClient apiClient, Set<DriveId> parentIds) {
        if (parentIds == null) {
            throw new IllegalArgumentException("ParentIds must be provided.");
        }
        if (parentIds.isEmpty()) {
            throw new IllegalArgumentException("ParentIds must contain at least one parent.");
        }
        final ArrayList<DriveId> arrayList = new ArrayList<DriveId>(parentIds);
        return apiClient.zzb((zza.zza)new zzr.zza(apiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zznO().zza(new SetResourceParentsRequest(zzz.this.zzVL, arrayList), (zzal)new zzbr((zza.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> updateMetadata(GoogleApiClient apiClient, final MetadataChangeSet changeSet) {
        if (changeSet == null) {
            throw new IllegalArgumentException("ChangeSet must be provided.");
        }
        return apiClient.zzb((zza.zza)new zzd(apiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                changeSet.zznz().setContext(zzs2.getContext());
                zzs2.zznO().zza(new UpdateMetadataRequest(zzz.this.zzVL, changeSet.zznz()), (zzal)new zzb((zza.zzb<DriveResource.MetadataResult>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> addChangeListener(GoogleApiClient apiClient, ChangeListener listener) {
        zzs zzs2 = (zzs)apiClient.zza(Drive.zzKh);
        return zzs2.zza(apiClient, this.zzVL, listener);
    }

    @Override
    public PendingResult<Status> removeChangeListener(GoogleApiClient apiClient, ChangeListener listener) {
        zzs zzs2 = (zzs)apiClient.zza(Drive.zzKh);
        return zzs2.zzb(apiClient, this.zzVL, listener);
    }

    @Override
    public PendingResult<Status> addChangeSubscription(GoogleApiClient apiClient) {
        zzs zzs2 = (zzs)apiClient.zza(Drive.zzKh);
        return zzs2.zza(apiClient, this.zzVL);
    }

    @Override
    public PendingResult<Status> removeChangeSubscription(GoogleApiClient apiClient) {
        zzs zzs2 = (zzs)apiClient.zza(Drive.zzKh);
        return zzs2.zzb(apiClient, this.zzVL);
    }

    @Override
    public PendingResult<Status> trash(GoogleApiClient apiClient) {
        return apiClient.zzb((zza.zza)new zzr.zza(apiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zznO().zza(new TrashResourceRequest(zzz.this.zzVL), (zzal)new zzbr((zza.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> untrash(GoogleApiClient apiClient) {
        return apiClient.zzb((zza.zza)new zzr.zza(apiClient){

            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zznO().zza(new UntrashResourceRequest(zzz.this.zzVL), (zzal)new zzbr((zza.zzb<Status>)this));
            }
        });
    }

    private static class zza
    extends com.google.android.gms.drive.internal.zzd {
        private final zza.zzb<DriveApi.MetadataBufferResult> zzKq;

        public zza(zza.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.zzKq = zzb2;
        }

        @Override
        public void zza(OnListParentsResponse onListParentsResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListParentsResponse.zzoe());
            this.zzKq.zzj((Object)new zzq.zzf(Status.zzQU, metadataBuffer, false));
        }

        @Override
        public void zzm(Status status) throws RemoteException {
            this.zzKq.zzj((Object)new zzq.zzf(status, null, false));
        }
    }

    private static class zzb
    extends com.google.android.gms.drive.internal.zzd {
        private final zza.zzb<DriveResource.MetadataResult> zzKq;

        public zzb(zza.zzb<DriveResource.MetadataResult> zzb2) {
            this.zzKq = zzb2;
        }

        @Override
        public void zza(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.zzKq.zzj((Object)new zzc(Status.zzQU, new zzn(onMetadataResponse.zzof())));
        }

        @Override
        public void zzm(Status status) throws RemoteException {
            this.zzKq.zzj((Object)new zzc(status, null));
        }
    }

    private static class zzc
    implements DriveResource.MetadataResult {
        private final Status zzKr;
        private final Metadata zzYw;

        public zzc(Status status, Metadata metadata) {
            this.zzKr = status;
            this.zzYw = metadata;
        }

        public Status getStatus() {
            return this.zzKr;
        }

        @Override
        public Metadata getMetadata() {
            return this.zzYw;
        }
    }

    private abstract class zzd
    extends zzr<DriveResource.MetadataResult> {
        private zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveResource.MetadataResult zzt(Status status) {
            return new zzc(status, null);
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzt(x0);
        }
    }
}

