/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.metadata.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.drive.internal.zzx;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.zze;
import com.google.android.gms.drive.metadata.internal.zzh;
import com.google.android.gms.internal.zzig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class MetadataBundle
implements SafeParcelable {
    public static final Parcelable.Creator<MetadataBundle> CREATOR = new zzh();
    final int zzzH;
    final Bundle zzZF;

    MetadataBundle(int versionCode, Bundle valueBundle) {
        this.zzzH = versionCode;
        this.zzZF = (Bundle)zzv.zzr((Object)valueBundle);
        this.zzZF.setClassLoader(this.getClass().getClassLoader());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.zzZF.keySet()) {
            if (zze.zzcd(string) != null) continue;
            arrayList.add(string);
            zzx.zzt("MetadataBundle", "Ignored unknown metadata field in bundle: " + string);
        }
        for (String string : arrayList) {
            this.zzZF.remove(string);
        }
    }

    private MetadataBundle(Bundle valueBundle) {
        this(1, valueBundle);
    }

    public static MetadataBundle zzok() {
        return new MetadataBundle(new Bundle());
    }

    public static MetadataBundle zza(MetadataBundle metadataBundle) {
        return new MetadataBundle(new Bundle(metadataBundle.zzZF));
    }

    public static <T> MetadataBundle zza(MetadataField<T> metadataField, T t) {
        MetadataBundle metadataBundle = MetadataBundle.zzok();
        metadataBundle.zzb(metadataField, t);
        return metadataBundle;
    }

    public <T> void zzb(MetadataField<T> metadataField, T t) {
        if (zze.zzcd(metadataField.getName()) == null) {
            throw new IllegalArgumentException("Unregistered field: " + metadataField.getName());
        }
        metadataField.zza(t, this.zzZF);
    }

    public <T> T zza(MetadataField<T> metadataField) {
        return metadataField.zzi(this.zzZF);
    }

    public boolean zzc(MetadataField<?> metadataField) {
        return this.zzZF.containsKey(metadataField.getName());
    }

    public Set<MetadataField<?>> zzol() {
        HashSet hashSet = new HashSet();
        for (String string : this.zzZF.keySet()) {
            hashSet.add(zze.zzcd(string));
        }
        return hashSet;
    }

    public void setContext(Context context) {
        BitmapTeleporter bitmapTeleporter = this.zza(zzig.zzaak);
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(context.getCacheDir());
        }
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        for (String string : this.zzZF.keySet()) {
            n2 = n2 * 31 + this.zzZF.get(string).hashCode();
        }
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetadataBundle)) {
            return false;
        }
        MetadataBundle metadataBundle = (MetadataBundle)obj;
        Set set = this.zzZF.keySet();
        if (!set.equals(metadataBundle.zzZF.keySet())) {
            return false;
        }
        for (String string : set) {
            if (zzu.equal((Object)this.zzZF.get(string), (Object)metadataBundle.zzZF.get(string))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "MetadataBundle [values=" + this.zzZF + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzh.zza(this, dest, flags);
    }
}

