/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.query;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.drive.DriveSpace;
import com.google.android.gms.drive.query.Filter;
import com.google.android.gms.drive.query.SortOrder;
import com.google.android.gms.drive.query.internal.LogicalFilter;
import com.google.android.gms.drive.query.internal.MatchAllFilter;
import com.google.android.gms.drive.query.internal.Operator;
import com.google.android.gms.drive.query.zza;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class Query
implements SafeParcelable {
    public static final Parcelable.Creator<Query> CREATOR = new zza();
    final LogicalFilter zzaaC;
    final String zzaaD;
    final SortOrder zzaaE;
    final List<String> zzaaF;
    final boolean zzaaG;
    final List<DriveSpace> zzWO;
    private final Set<DriveSpace> zzWP;
    final int zzzH;

    private Query(int versionCode, LogicalFilter clause, String pageToken, SortOrder sortOrder, List<String> requestedMetadataFields, boolean shouldIncludeParents, List<DriveSpace> spacesList, Set<DriveSpace> spaces) {
        this.zzzH = versionCode;
        this.zzaaC = clause;
        this.zzaaD = pageToken;
        this.zzaaE = sortOrder;
        this.zzaaF = requestedMetadataFields;
        this.zzaaG = shouldIncludeParents;
        this.zzWO = spacesList;
        this.zzWP = spaces;
    }

    private Query(LogicalFilter clause, String pageToken, SortOrder sortOrder, List<String> requestedMetadataFields, boolean shouldIncludeParents, Set<DriveSpace> spaces) {
        this(1, clause, pageToken, sortOrder, requestedMetadataFields, shouldIncludeParents, (List<DriveSpace>)(spaces == null ? null : new ArrayList<DriveSpace>(spaces)), spaces);
    }

    Query(int versionCode, LogicalFilter clause, String pageToken, SortOrder sortOrder, List<String> requestedMetadataFields, boolean shouldIncludeParents, List<DriveSpace> spacesList) {
        this(versionCode, clause, pageToken, sortOrder, requestedMetadataFields, shouldIncludeParents, spacesList, (Set<DriveSpace>)(spacesList == null ? null : new HashSet<DriveSpace>(spacesList)));
    }

    public Filter getFilter() {
        return this.zzaaC;
    }

    @Deprecated
    public String getPageToken() {
        return this.zzaaD;
    }

    public SortOrder getSortOrder() {
        return this.zzaaE;
    }

    public List<String> zzom() {
        return this.zzaaF;
    }

    public boolean zzon() {
        return this.zzaaG;
    }

    public Set<DriveSpace> zzoo() {
        return this.zzWP;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    public String toString() {
        return String.format(Locale.US, "Query[%s,%s,PageToken=%s,Spaces=%s]", this.zzaaC, this.zzaaE, this.zzaaD, this.zzWO);
    }

    public static class Builder {
        private final List<Filter> zzaaH = new ArrayList<Filter>();
        private String zzaaD;
        private SortOrder zzaaE;
        private List<String> zzaaF;
        private boolean zzaaG;
        private Set<DriveSpace> zzWP;

        public Builder() {
        }

        public Builder(Query query) {
            this.zzaaH.add(query.getFilter());
            this.zzaaD = query.getPageToken();
            this.zzaaE = query.getSortOrder();
            this.zzaaF = query.zzom();
            this.zzaaG = query.zzon();
            this.zzWP = query.zzoo();
        }

        public Builder addFilter(Filter filter) {
            if (!(filter instanceof MatchAllFilter)) {
                this.zzaaH.add(filter);
            }
            return this;
        }

        public Builder setSortOrder(SortOrder sortOrder) {
            this.zzaaE = sortOrder;
            return this;
        }

        @Deprecated
        public Builder setPageToken(String token) {
            this.zzaaD = token;
            return this;
        }

        public Query build() {
            return new Query(new LogicalFilter(Operator.zzabh, this.zzaaH), this.zzaaD, this.zzaaE, this.zzaaF, this.zzaaG, this.zzWP);
        }
    }
}

