/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.query;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.drive.metadata.SortableMetadataField;
import com.google.android.gms.drive.query.internal.FieldWithSortOrder;
import com.google.android.gms.drive.query.zzb;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SortOrder
implements SafeParcelable {
    public static final Parcelable.Creator<SortOrder> CREATOR = new zzb();
    final List<FieldWithSortOrder> zzaaK;
    final boolean zzaaL;
    final int zzzH;

    private SortOrder(List<FieldWithSortOrder> sortingFields, boolean sortFolderFirst) {
        this(1, sortingFields, sortFolderFirst);
    }

    SortOrder(int versionCode, List<FieldWithSortOrder> sortingFields, boolean sortFolderFirst) {
        this.zzzH = versionCode;
        this.zzaaK = sortingFields;
        this.zzaaL = sortFolderFirst;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzb.zza(this, out, flags);
    }

    public String toString() {
        return String.format(Locale.US, "SortOrder[%s, %s]", TextUtils.join((CharSequence)",", this.zzaaK), this.zzaaL);
    }

    public static class Builder {
        private final List<FieldWithSortOrder> zzaaK = new ArrayList<FieldWithSortOrder>();
        private boolean zzaaL = false;

        public Builder addSortAscending(SortableMetadataField sortField) {
            this.zzaaK.add(new FieldWithSortOrder(sortField.getName(), true));
            return this;
        }

        public Builder addSortDescending(SortableMetadataField sortField) {
            this.zzaaK.add(new FieldWithSortOrder(sortField.getName(), false));
            return this;
        }

        public SortOrder build() {
            return new SortOrder(this.zzaaK, this.zzaaL);
        }
    }
}

