/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.internal.zzab;
import com.google.android.gms.drive.internal.zzat;
import com.google.android.gms.drive.internal.zzau;
import com.google.android.gms.drive.internal.zzw;
import com.google.android.gms.drive.internal.zzy;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.drive.zze;
import com.google.android.gms.internal.zzsd;
import com.google.android.gms.internal.zzse;

public class DriveId
implements SafeParcelable {
    public static final int RESOURCE_TYPE_UNKNOWN = -1;
    public static final int RESOURCE_TYPE_FILE = 0;
    public static final int RESOURCE_TYPE_FOLDER = 1;
    public static final Parcelable.Creator<DriveId> CREATOR = new zze();
    final int mVersionCode;
    final String zzaiM;
    final long zzaiN;
    final long zzaiv;
    final int zzaiO;
    private volatile String zzaix = null;
    private volatile String zzaiP = null;

    public static DriveId zzcB(String string) {
        zzx.zzw((Object)string);
        return new DriveId(string, -1L, -1L, -1);
    }

    public String getResourceId() {
        return this.zzaiM;
    }

    public int getResourceType() {
        return this.zzaiO;
    }

    public DriveFile asDriveFile() {
        if (this.zzaiO == 1) {
            throw new IllegalStateException("This DriveId corresponds to a folder. Call asDriveFolder instead.");
        }
        return new zzw(this);
    }

    public DriveFolder asDriveFolder() {
        if (this.zzaiO == 0) {
            throw new IllegalStateException("This DriveId corresponds to a file. Call asDriveFile instead.");
        }
        return new zzy(this);
    }

    public DriveResource asDriveResource() {
        if (this.zzaiO == 1) {
            return this.asDriveFolder();
        }
        if (this.zzaiO == 0) {
            return this.asDriveFile();
        }
        return new zzab(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zze.zza(this, out, flags);
    }

    DriveId(int versionCode, String resourceId, long sqlId, long databaseInstanceId, int resourceType) {
        this.mVersionCode = versionCode;
        this.zzaiM = resourceId;
        zzx.zzaa((!"".equals(resourceId) ? 1 : 0) != 0);
        zzx.zzaa((resourceId != null || sqlId != -1L ? 1 : 0) != 0);
        this.zzaiN = sqlId;
        this.zzaiv = databaseInstanceId;
        this.zzaiO = resourceType;
    }

    public DriveId(String resourceId, long sqlId, long databaseInstanceId, int resourceType) {
        this(1, resourceId, sqlId, databaseInstanceId, resourceType);
    }

    public int hashCode() {
        if (this.zzaiN == -1L) {
            return this.zzaiM.hashCode();
        }
        return (String.valueOf(this.zzaiv) + String.valueOf(this.zzaiN)).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DriveId)) {
            return false;
        }
        DriveId driveId = (DriveId)obj;
        if (driveId.zzaiv != this.zzaiv) {
            zzz.zzy("DriveId", "Attempt to compare invalid DriveId detected. Has local storage been cleared?");
            return false;
        }
        if (driveId.zzaiN == -1L && this.zzaiN == -1L) {
            return driveId.zzaiM.equals(this.zzaiM);
        }
        if (this.zzaiM == null || driveId.zzaiM == null) {
            return driveId.zzaiN == this.zzaiN;
        }
        if (driveId.zzaiN == this.zzaiN) {
            if (driveId.zzaiM.equals(this.zzaiM)) {
                return true;
            }
            zzz.zzy("DriveId", "Unexpected unequal resourceId for same DriveId object.");
        }
        return false;
    }

    public final String encodeToString() {
        if (this.zzaix == null) {
            byte[] byArray = this.zzqL();
            String string = Base64.encodeToString((byte[])byArray, (int)10);
            this.zzaix = "DriveId:" + string;
        }
        return this.zzaix;
    }

    public final String toInvariantString() {
        if (this.zzaiP == null) {
            byte[] byArray = this.zzqR();
            this.zzaiP = Base64.encodeToString((byte[])byArray, (int)10);
        }
        return this.zzaiP;
    }

    final byte[] zzqL() {
        zzat zzat2 = new zzat();
        zzat2.versionCode = this.mVersionCode;
        zzat2.zzalQ = this.zzaiM == null ? "" : this.zzaiM;
        zzat2.zzalR = this.zzaiN;
        zzat2.zzalO = this.zzaiv;
        zzat2.zzalS = this.zzaiO;
        byte[] byArray = zzse.zzf((zzse)zzat2);
        return byArray;
    }

    private byte[] zzqR() {
        zzau zzau2 = new zzau();
        zzau2.zzalR = this.zzaiN;
        zzau2.zzalO = this.zzaiv;
        byte[] byArray = zzse.zzf((zzse)zzau2);
        return byArray;
    }

    public String toString() {
        return this.encodeToString();
    }

    public static DriveId decodeFromString(String s) {
        zzx.zzb((boolean)s.startsWith("DriveId:"), (Object)("Invalid DriveId: " + s));
        String string = s.substring("DriveId:".length());
        byte[] byArray = Base64.decode((String)string, (int)10);
        return DriveId.zzk(byArray);
    }

    static DriveId zzk(byte[] byArray) {
        zzat zzat2;
        try {
            zzat2 = zzat.zzl(byArray);
        }
        catch (zzsd zzsd2) {
            throw new IllegalArgumentException();
        }
        String string = "".equals(zzat2.zzalQ) ? null : zzat2.zzalQ;
        DriveId driveId = new DriveId(zzat2.versionCode, string, zzat2.zzalR, zzat2.zzalO, zzat2.zzalS);
        return driveId;
    }
}

