/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.internal.zzu;

public final class ExecutionOptions {
    public static final int MAX_TRACKING_TAG_STRING_LENGTH = 65536;
    public static final int CONFLICT_STRATEGY_OVERWRITE_REMOTE = 0;
    public static final int CONFLICT_STRATEGY_KEEP_REMOTE = 1;
    private final String zzaiX;
    private final boolean zzaiY;
    private final int zzaiZ;

    public ExecutionOptions(String trackingTag, boolean notifyOnCompletion, int conflictStrategy) {
        this.zzaiX = trackingTag;
        this.zzaiY = notifyOnCompletion;
        this.zzaiZ = conflictStrategy;
    }

    public String zzqS() {
        return this.zzaiX;
    }

    public boolean zzqT() {
        return this.zzaiY;
    }

    public int zzqU() {
        return this.zzaiZ;
    }

    public static boolean zzck(int n) {
        switch (n) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean zzcl(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean zzcC(String string) {
        return string != null && !string.isEmpty() && string.length() <= 65536;
    }

    public static void zza(GoogleApiClient googleApiClient, ExecutionOptions executionOptions) {
        zzu zzu2 = (zzu)googleApiClient.zza(Drive.zzRk);
        if (executionOptions.zzqT() && !zzu2.zzrq()) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to be notified on completion");
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ExecutionOptions executionOptions = (ExecutionOptions)o;
        return zzw.equal((Object)this.zzaiX, (Object)executionOptions.zzaiX) && this.zzaiZ == executionOptions.zzaiZ && this.zzaiY == executionOptions.zzaiY;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzaiX, this.zzaiZ, this.zzaiY});
    }

    public static final class Builder {
        private String zzaiX;
        private boolean zzaiY;
        private int zzaiZ = 0;

        public Builder setTrackingTag(String trackingTag) {
            if (!ExecutionOptions.zzcC(trackingTag)) {
                throw new IllegalArgumentException(String.format("trackingTag must not be null nor empty, and the length must be <= the maximum length (%s)", 65536));
            }
            this.zzaiX = trackingTag;
            return this;
        }

        public Builder setNotifyOnCompletion(boolean notify) {
            this.zzaiY = notify;
            return this;
        }

        public Builder setConflictStrategy(int strategy) {
            if (!ExecutionOptions.zzcl(strategy)) {
                throw new IllegalArgumentException("Unrecognized value for conflict strategy: " + strategy);
            }
            this.zzaiZ = strategy;
            return this;
        }

        public ExecutionOptions build() {
            if (this.zzaiZ == 1 && !this.zzaiY) {
                throw new IllegalStateException("Cannot use CONFLICT_STRATEGY_KEEP_REMOTE without requesting completion notifications");
            }
            return new ExecutionOptions(this.zzaiX, this.zzaiY, this.zzaiZ);
        }
    }
}

