/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.content.IntentSender;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.internal.OpenFileIntentSenderRequest;
import com.google.android.gms.drive.internal.zzam;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.query.Filter;
import com.google.android.gms.drive.query.internal.FilterHolder;
import com.google.android.gms.drive.query.internal.zzg;

public class OpenFileActivityBuilder {
    public static final String EXTRA_RESPONSE_DRIVE_ID = "response_drive_id";
    private String zzajf;
    private String[] zzajg;
    private Filter zzajh;
    private DriveId zzaji;

    public OpenFileActivityBuilder setActivityTitle(String title) {
        this.zzajf = (String)zzx.zzw((Object)title);
        return this;
    }

    public OpenFileActivityBuilder setMimeType(String[] mimeTypes) {
        zzx.zzb((mimeTypes != null ? 1 : 0) != 0, (Object)"mimeTypes may not be null");
        this.zzajg = mimeTypes;
        return this;
    }

    public OpenFileActivityBuilder setSelectionFilter(Filter filter) {
        zzx.zzb((filter != null ? 1 : 0) != 0, (Object)"filter may not be null");
        zzx.zzb((!zzg.zza(filter) ? 1 : 0) != 0, (Object)"FullTextSearchFilter cannot be used as a selection filter");
        this.zzajh = filter;
        return this;
    }

    public OpenFileActivityBuilder setActivityStartFolder(DriveId folder) {
        this.zzaji = (DriveId)zzx.zzw((Object)folder);
        return this;
    }

    public IntentSender build(GoogleApiClient apiClient) {
        zzx.zza((boolean)apiClient.isConnected(), (Object)"Client must be connected");
        if (this.zzajg == null) {
            this.zzajg = new String[0];
        }
        if (this.zzajg.length > 0 && this.zzajh != null) {
            throw new IllegalStateException("Cannot use a selection filter and set mimetypes simultaneously");
        }
        FilterHolder filterHolder = this.zzajh == null ? null : new FilterHolder(this.zzajh);
        try {
            zzam zzam2 = ((zzu)apiClient.zza(Drive.zzRk)).zzrm();
            return zzam2.zza(new OpenFileIntentSenderRequest(this.zzajf, this.zzajg, this.zzaji, filterHolder));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Unable to connect Drive Play Service", remoteException);
        }
    }
}

