/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.zze;
import com.google.android.gms.drive.internal.zzap;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzmt;
import com.google.android.gms.internal.zznd;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
implements SafeParcelable,
ResourceEvent {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final int STATUS_CANCELED = 3;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new zze();
    final int mVersionCode;
    final DriveId zzaiA;
    final String zzRs;
    final ParcelFileDescriptor zzajC;
    final ParcelFileDescriptor zzajD;
    final MetadataBundle zzajE;
    final List<String> zzajF;
    final int zzys;
    final IBinder zzajG;
    private boolean zzajH = false;
    private boolean zzajI = false;
    private boolean zzajJ = false;

    CompletionEvent(int versionCode, DriveId driveId, String accountName, ParcelFileDescriptor baseParcelFileDescriptor, ParcelFileDescriptor modifiedParcelFileDescriptor, MetadataBundle modifiedMetadataBundle, List<String> trackingTags, int status, IBinder releaseCallback) {
        this.mVersionCode = versionCode;
        this.zzaiA = driveId;
        this.zzRs = accountName;
        this.zzajC = baseParcelFileDescriptor;
        this.zzajD = modifiedParcelFileDescriptor;
        this.zzajE = modifiedMetadataBundle;
        this.zzajF = trackingTags;
        this.zzys = status;
        this.zzajG = releaseCallback;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zze.zza(this, dest, flags | 1);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public DriveId getDriveId() {
        this.zzre();
        return this.zzaiA;
    }

    public String getAccountName() {
        this.zzre();
        return this.zzRs;
    }

    public InputStream getBaseContentsInputStream() {
        this.zzre();
        if (this.zzajC == null) {
            return null;
        }
        if (this.zzajH) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzajH = true;
        return new FileInputStream(this.zzajC.getFileDescriptor());
    }

    public InputStream getModifiedContentsInputStream() {
        this.zzre();
        if (this.zzajD == null) {
            return null;
        }
        if (this.zzajI) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzajI = true;
        return new FileInputStream(this.zzajD.getFileDescriptor());
    }

    public MetadataChangeSet getModifiedMetadataChangeSet() {
        this.zzre();
        return this.zzajE != null ? new MetadataChangeSet(this.zzajE) : null;
    }

    public List<String> getTrackingTags() {
        this.zzre();
        return new ArrayList<String>(this.zzajF);
    }

    public int getStatus() {
        this.zzre();
        return this.zzys;
    }

    public void dismiss() {
        this.zzt(false);
    }

    public void snooze() {
        this.zzt(true);
    }

    private void zzt(boolean bl) {
        this.zzre();
        this.zzajJ = true;
        zzmt.zza((ParcelFileDescriptor)this.zzajC);
        zzmt.zza((ParcelFileDescriptor)this.zzajD);
        if (this.zzajE != null && this.zzajE.zzc(zznd.zzano)) {
            this.zzajE.zza(zznd.zzano).release();
        }
        if (this.zzajG == null) {
            zzz.zzz("CompletionEvent", "No callback on " + (bl ? "snooze" : "dismiss"));
            return;
        }
        try {
            zzap.zza.zzaV(this.zzajG).zzt(bl);
        }
        catch (RemoteException remoteException) {
            zzz.zzz("CompletionEvent", "RemoteException on " + (bl ? "snooze" : "dismiss") + ": " + (Object)((Object)remoteException));
        }
    }

    private void zzre() {
        if (this.zzajJ) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public String toString() {
        String string = this.zzajF == null ? "<null>" : "'" + TextUtils.join((CharSequence)"','", this.zzajF) + "'";
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", this.zzaiA, this.zzys, string);
    }
}

