/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.ChangesAvailableEvent;
import com.google.android.gms.drive.events.CompletionEvent;
import com.google.android.gms.drive.events.CompletionListener;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.events.zzc;
import com.google.android.gms.drive.internal.OnEventResponse;
import com.google.android.gms.drive.internal.zzao;
import com.google.android.gms.drive.internal.zzz;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class DriveEventService
extends Service
implements ChangeListener,
CompletionListener,
zzc {
    public static final String ACTION_HANDLE_EVENT = "com.google.android.gms.drive.events.HANDLE_EVENT";
    private final String mName;
    private CountDownLatch zzajK;
    zza zzajL;
    boolean zzajM = false;
    int zzaeG = -1;

    protected DriveEventService(String name) {
        this.mName = name;
    }

    protected DriveEventService() {
        this("DriveEventService");
    }

    public final synchronized IBinder onBind(Intent intent) {
        if (ACTION_HANDLE_EVENT.equals(intent.getAction())) {
            if (this.zzajL == null && !this.zzajM) {
                this.zzajM = true;
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                this.zzajK = new CountDownLatch(1);
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Looper.prepare();
                            DriveEventService.this.zzajL = new zza();
                            DriveEventService.this.zzajM = false;
                            countDownLatch.countDown();
                            zzz.zzx("DriveEventService", "Bound and starting loop");
                            Looper.loop();
                            zzz.zzx("DriveEventService", "Finished loop");
                        }
                        finally {
                            if (DriveEventService.this.zzajK != null) {
                                DriveEventService.this.zzajK.countDown();
                            }
                        }
                    }
                }.start();
                try {
                    boolean bl = countDownLatch.await(5000L, TimeUnit.MILLISECONDS);
                    if (!bl) {
                        zzz.zzz("DriveEventService", "Failed to synchronously initialize event handler.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Unable to start event handler", interruptedException);
                }
            }
            return new zzb().asBinder();
        }
        return null;
    }

    public boolean onUnbind(Intent intent) {
        return true;
    }

    public synchronized void onDestroy() {
        zzz.zzx("DriveEventService", "onDestroy");
        if (this.zzajL != null) {
            Message message = this.zzajL.zzrg();
            this.zzajL.sendMessage(message);
            this.zzajL = null;
            try {
                boolean bl = this.zzajK.await(5000L, TimeUnit.MILLISECONDS);
                if (!bl) {
                    zzz.zzy("DriveEventService", "Failed to synchronously quit event handler. Will quit itself");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.zzajK = null;
        }
        super.onDestroy();
    }

    @Override
    public void onChange(ChangeEvent event) {
        zzz.zzy(this.mName, "Unhandled change event: " + event);
    }

    @Override
    public void zza(ChangesAvailableEvent changesAvailableEvent) {
        zzz.zzy(this.mName, "Unhandled changes available event: " + changesAvailableEvent);
    }

    @Override
    public void onCompletion(CompletionEvent event) {
        zzz.zzy(this.mName, "Unhandled completion event: " + event);
    }

    protected int getCallingUid() {
        return Binder.getCallingUid();
    }

    private void zza(OnEventResponse onEventResponse) {
        DriveEvent driveEvent = onEventResponse.zzrA();
        zzz.zzx("DriveEventService", "handleEventMessage: " + driveEvent);
        try {
            switch (driveEvent.getType()) {
                case 1: {
                    this.onChange((ChangeEvent)driveEvent);
                    break;
                }
                case 2: {
                    this.onCompletion((CompletionEvent)driveEvent);
                    break;
                }
                case 4: {
                    this.zza((ChangesAvailableEvent)driveEvent);
                    break;
                }
                default: {
                    zzz.zzy(this.mName, "Unhandled event: " + driveEvent);
                    break;
                }
            }
        }
        catch (Exception exception) {
            zzz.zza(this.mName, exception, "Error handling event: " + driveEvent);
        }
    }

    private void zzrf() throws SecurityException {
        int n = this.getCallingUid();
        if (n == this.zzaeG) {
            return;
        }
        if (GooglePlayServicesUtil.zze((Context)this, (int)n)) {
            this.zzaeG = n;
            return;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    final class zzb
    extends zzao.zza {
        zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzc(OnEventResponse onEventResponse) throws RemoteException {
            DriveEventService driveEventService = DriveEventService.this;
            synchronized (driveEventService) {
                zzz.zzx("DriveEventService", "onEvent: " + onEventResponse);
                DriveEventService.this.zzrf();
                if (DriveEventService.this.zzajL != null) {
                    Message message = DriveEventService.this.zzajL.zzb(onEventResponse);
                    DriveEventService.this.zzajL.sendMessage(message);
                } else {
                    zzz.zzz("DriveEventService", "Receiving event before initialize is completed.");
                }
            }
        }
    }

    final class zza
    extends Handler {
        zza() {
        }

        private Message zzb(OnEventResponse onEventResponse) {
            return this.obtainMessage(1, onEventResponse);
        }

        private Message zzrg() {
            return this.obtainMessage(2);
        }

        public void handleMessage(Message msg) {
            zzz.zzx("DriveEventService", "handleMessage message type:" + msg.what);
            switch (msg.what) {
                case 1: {
                    DriveEventService.this.zza((OnEventResponse)msg.obj);
                    break;
                }
                case 2: {
                    this.getLooper().quit();
                    break;
                }
                default: {
                    zzz.zzy("DriveEventService", "Unexpected message type:" + msg.what);
                }
            }
        }
    }
}

