/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.BooleanResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.CreateFileActivityBuilder;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.OpenFileActivityBuilder;
import com.google.android.gms.drive.internal.CreateContentsRequest;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.OnContentsResponse;
import com.google.android.gms.drive.internal.OnDriveIdResponse;
import com.google.android.gms.drive.internal.OnListEntriesResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.QueryRequest;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzbt;
import com.google.android.gms.drive.internal.zzp;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.internal.zzv;
import com.google.android.gms.drive.internal.zzw;
import com.google.android.gms.drive.internal.zzy;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.internal.zzlb;
import java.util.List;

public class zzs
implements DriveApi {
    @Override
    public PendingResult<DriveApi.MetadataBufferResult> query(GoogleApiClient apiClient, final Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be provided.");
        }
        return apiClient.zza((zzlb.zza)new zzg(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzrm().zza(new QueryRequest(query), (zzan)new zzi((zzlb.zzb<DriveApi.MetadataBufferResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> newDriveContents(GoogleApiClient apiClient) {
        return this.zza(apiClient, 0x20000000);
    }

    public PendingResult<DriveApi.DriveContentsResult> zza(GoogleApiClient googleApiClient, final int n) {
        return googleApiClient.zza((zzlb.zza)new zzb(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzrm().zza(new CreateContentsRequest(n), (zzan)new zzh((zzlb.zzb<DriveApi.DriveContentsResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveIdResult> fetchDriveId(GoogleApiClient apiClient, final String resourceId) {
        return apiClient.zza((zzlb.zza)new zze(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzrm().zza(new GetMetadataRequest(DriveId.zzcB(resourceId), false), (zzan)new zzc((zzlb.zzb<DriveApi.DriveIdResult>)this));
            }
        });
    }

    @Override
    public DriveFile getFile(GoogleApiClient apiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzw(driveId);
    }

    @Override
    public DriveFolder getFolder(GoogleApiClient apiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzy(driveId);
    }

    @Override
    public DriveFolder getRootFolder(GoogleApiClient apiClient) {
        zzu zzu2 = (zzu)apiClient.zza(Drive.zzRk);
        if (!zzu2.zzrp()) {
            throw new IllegalStateException("Client is not yet connected");
        }
        return new zzy(zzu2.zzrn());
    }

    @Override
    public DriveFolder getAppFolder(GoogleApiClient apiClient) {
        zzu zzu2 = (zzu)apiClient.zza(Drive.zzRk);
        if (!zzu2.zzrp()) {
            throw new IllegalStateException("Client is not yet connected");
        }
        DriveId driveId = zzu2.zzro();
        return driveId != null ? new zzy(driveId) : null;
    }

    @Override
    public PendingResult<Status> requestSync(GoogleApiClient apiClient) {
        return apiClient.zzb((zzlb.zza)new zzt.zza(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzrm().zza(new zzbt((zzlb.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<BooleanResult> isAutobackupEnabled(GoogleApiClient apiClient) {
        return apiClient.zza((zzlb.zza)new zzt<BooleanResult>(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                final 5 var2_2 = this;
                zzu2.zzrm().zze(new com.google.android.gms.drive.internal.zzd(){

                    @Override
                    public void zzab(boolean bl) {
                        var2_2.zzb((Result)new BooleanResult(Status.zzabb, bl));
                    }
                });
            }

            protected BooleanResult zzz(Status status) {
                return new BooleanResult(status, false);
            }

            protected /* synthetic */ Result zzb(Status status) {
                return this.zzz(status);
            }
        });
    }

    @Override
    public OpenFileActivityBuilder newOpenFileActivityBuilder() {
        return new OpenFileActivityBuilder();
    }

    @Override
    public CreateFileActivityBuilder newCreateFileActivityBuilder() {
        return new CreateFileActivityBuilder();
    }

    @Override
    public PendingResult<Status> cancelPendingActions(GoogleApiClient apiClient, List<String> trackingTags) {
        zzu zzu2 = (zzu)apiClient.zza(Drive.zzRk);
        return zzu2.cancelPendingActions(apiClient, trackingTags);
    }

    private static class zzi
    extends com.google.android.gms.drive.internal.zzd {
        private final zzlb.zzb<DriveApi.MetadataBufferResult> zzagy;

        public zzi(zzlb.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.zzagy = zzb2;
        }

        @Override
        public void zza(OnListEntriesResponse onListEntriesResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListEntriesResponse.zzrB());
            this.zzagy.zzp((Object)new zzf(Status.zzabb, metadataBuffer, onListEntriesResponse.zzrC()));
        }

        @Override
        public void zzy(Status status) throws RemoteException {
            this.zzagy.zzp((Object)new zzf(status, null, false));
        }
    }

    static class zzf
    implements DriveApi.MetadataBufferResult {
        private final Status zzSC;
        private final MetadataBuffer zzakA;
        private final boolean zzakB;

        public zzf(Status status, MetadataBuffer metadataBuffer, boolean bl) {
            this.zzSC = status;
            this.zzakA = metadataBuffer;
            this.zzakB = bl;
        }

        public Status getStatus() {
            return this.zzSC;
        }

        @Override
        public MetadataBuffer getMetadataBuffer() {
            return this.zzakA;
        }

        public void release() {
            if (this.zzakA != null) {
                this.zzakA.release();
            }
        }
    }

    static abstract class zzg
    extends zzt<DriveApi.MetadataBufferResult> {
        zzg(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.MetadataBufferResult zzC(Status status) {
            return new zzf(status, null, false);
        }

        public /* synthetic */ Result zzb(Status status) {
            return this.zzC(status);
        }
    }

    static class zzc
    extends com.google.android.gms.drive.internal.zzd {
        private final zzlb.zzb<DriveApi.DriveIdResult> zzagy;

        public zzc(zzlb.zzb<DriveApi.DriveIdResult> zzb2) {
            this.zzagy = zzb2;
        }

        @Override
        public void zza(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.zzagy.zzp((Object)new zzd(Status.zzabb, new zzp(onMetadataResponse.zzrE()).getDriveId()));
        }

        @Override
        public void zza(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.zzagy.zzp((Object)new zzd(Status.zzabb, onDriveIdResponse.getDriveId()));
        }

        @Override
        public void zzy(Status status) throws RemoteException {
            this.zzagy.zzp((Object)new zzd(status, null));
        }
    }

    private static class zzd
    implements DriveApi.DriveIdResult {
        private final Status zzSC;
        private final DriveId zzaiA;

        public zzd(Status status, DriveId driveId) {
            this.zzSC = status;
            this.zzaiA = driveId;
        }

        public Status getStatus() {
            return this.zzSC;
        }

        @Override
        public DriveId getDriveId() {
            return this.zzaiA;
        }
    }

    static abstract class zze
    extends zzt<DriveApi.DriveIdResult> {
        zze(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveIdResult zzB(Status status) {
            return new zzd(status, null);
        }

        public /* synthetic */ Result zzb(Status status) {
            return this.zzB(status);
        }
    }

    private static class zzh
    extends com.google.android.gms.drive.internal.zzd {
        private final zzlb.zzb<DriveApi.DriveContentsResult> zzagy;

        public zzh(zzlb.zzb<DriveApi.DriveContentsResult> zzb2) {
            this.zzagy = zzb2;
        }

        @Override
        public void zza(OnContentsResponse onContentsResponse) throws RemoteException {
            this.zzagy.zzp((Object)new zza(Status.zzabb, new zzv(onContentsResponse.zzrv())));
        }

        @Override
        public void zzy(Status status) throws RemoteException {
            this.zzagy.zzp((Object)new zza(status, null));
        }
    }

    static class zza
    implements Releasable,
    DriveApi.DriveContentsResult {
        private final Status zzSC;
        private final DriveContents zzaiD;

        public zza(Status status, DriveContents driveContents) {
            this.zzSC = status;
            this.zzaiD = driveContents;
        }

        public Status getStatus() {
            return this.zzSC;
        }

        @Override
        public DriveContents getDriveContents() {
            return this.zzaiD;
        }

        public void release() {
            if (this.zzaiD != null) {
                this.zzaiD.zzqP();
            }
        }
    }

    static abstract class zzb
    extends zzt<DriveApi.DriveContentsResult> {
        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveContentsResult zzA(Status status) {
            return new zza(status, null);
        }

        public /* synthetic */ Result zzb(Status status) {
            return this.zzA(status);
        }
    }

    static class zzj
    extends zzt.zza {
        zzj(GoogleApiClient googleApiClient, Status status) {
            super(googleApiClient);
            this.zzb((Result)status);
        }

        protected void zza(zzu zzu2) {
        }
    }
}

