/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.internal.zzu;

public final class ExecutionOptions {
    public static final int MAX_TRACKING_TAG_STRING_LENGTH = 65536;
    public static final int CONFLICT_STRATEGY_OVERWRITE_REMOTE = 0;
    public static final int CONFLICT_STRATEGY_KEEP_REMOTE = 1;
    private final String zzanc;
    private final boolean zzand;
    private final int zzane;

    public ExecutionOptions(String trackingTag, boolean notifyOnCompletion, int conflictStrategy) {
        this.zzanc = trackingTag;
        this.zzand = notifyOnCompletion;
        this.zzane = conflictStrategy;
    }

    public String zzsl() {
        return this.zzanc;
    }

    public boolean zzsm() {
        return this.zzand;
    }

    public int zzsn() {
        return this.zzane;
    }

    public static boolean zzcy(int n) {
        switch (n) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean zzcz(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean zzcR(String string) {
        return string != null && !string.isEmpty() && string.length() <= 65536;
    }

    public static void zza(GoogleApiClient googleApiClient, ExecutionOptions executionOptions) {
        zzu zzu2 = (zzu)googleApiClient.zza(Drive.zzTo);
        if (executionOptions.zzsm() && !zzu2.zzsJ()) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to be notified on completion");
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ExecutionOptions executionOptions = (ExecutionOptions)o;
        return zzw.equal((Object)this.zzanc, (Object)executionOptions.zzanc) && this.zzane == executionOptions.zzane && this.zzand == executionOptions.zzand;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzanc, this.zzane, this.zzand});
    }

    public static final class Builder {
        private String zzanc;
        private boolean zzand;
        private int zzane = 0;

        public Builder setTrackingTag(String trackingTag) {
            if (!ExecutionOptions.zzcR(trackingTag)) {
                throw new IllegalArgumentException(String.format("trackingTag must not be null nor empty, and the length must be <= the maximum length (%s)", 65536));
            }
            this.zzanc = trackingTag;
            return this;
        }

        public Builder setNotifyOnCompletion(boolean notify) {
            this.zzand = notify;
            return this;
        }

        public Builder setConflictStrategy(int strategy) {
            if (!ExecutionOptions.zzcz(strategy)) {
                throw new IllegalArgumentException("Unrecognized value for conflict strategy: " + strategy);
            }
            this.zzane = strategy;
            return this;
        }

        public ExecutionOptions build() {
            if (this.zzane == 1 && !this.zzand) {
                throw new IllegalStateException("Cannot use CONFLICT_STRATEGY_KEEP_REMOTE without requesting completion notifications");
            }
            return new ExecutionOptions(this.zzanc, this.zzand, this.zzane);
        }
    }
}

