/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.BooleanResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.CreateFileActivityBuilder;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.OpenFileActivityBuilder;
import com.google.android.gms.drive.internal.CreateContentsRequest;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.OnContentsResponse;
import com.google.android.gms.drive.internal.OnDriveIdResponse;
import com.google.android.gms.drive.internal.OnListEntriesResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.QueryRequest;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzbt;
import com.google.android.gms.drive.internal.zzp;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.internal.zzv;
import com.google.android.gms.drive.internal.zzw;
import com.google.android.gms.drive.internal.zzy;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.internal.zzlx;
import java.util.List;

public class zzs
implements DriveApi {
    @Override
    public PendingResult<DriveApi.MetadataBufferResult> query(GoogleApiClient apiClient, final Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be provided.");
        }
        return apiClient.zza((zzlx.zza)new zzh(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzsF().zza(new QueryRequest(query), (zzan)new zzi((zzlx.zzb<DriveApi.MetadataBufferResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> newDriveContents(GoogleApiClient apiClient) {
        return this.zza(apiClient, 0x20000000);
    }

    public PendingResult<DriveApi.DriveContentsResult> zza(GoogleApiClient googleApiClient, final int n) {
        return googleApiClient.zza((zzlx.zza)new zzc(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzsF().zza(new CreateContentsRequest(n), (zzan)new zza((zzlx.zzb<DriveApi.DriveContentsResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveIdResult> fetchDriveId(GoogleApiClient apiClient, final String resourceId) {
        return apiClient.zza((zzlx.zza)new zzf(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzsF().zza(new GetMetadataRequest(DriveId.zzcQ(resourceId), false), (zzan)new zzd((zzlx.zzb<DriveApi.DriveIdResult>)this));
            }
        });
    }

    @Override
    public DriveFile getFile(GoogleApiClient apiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzw(driveId);
    }

    @Override
    public DriveFolder getFolder(GoogleApiClient apiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzy(driveId);
    }

    @Override
    public DriveFolder getRootFolder(GoogleApiClient apiClient) {
        zzu zzu2 = (zzu)apiClient.zza(Drive.zzTo);
        if (!zzu2.zzsI()) {
            throw new IllegalStateException("Client is not yet connected");
        }
        DriveId driveId = zzu2.zzsG();
        return driveId != null ? new zzy(driveId) : null;
    }

    @Override
    public DriveFolder getAppFolder(GoogleApiClient apiClient) {
        zzu zzu2 = (zzu)apiClient.zza(Drive.zzTo);
        if (!zzu2.zzsI()) {
            throw new IllegalStateException("Client is not yet connected");
        }
        DriveId driveId = zzu2.zzsH();
        return driveId != null ? new zzy(driveId) : null;
    }

    @Override
    public PendingResult<Status> requestSync(GoogleApiClient apiClient) {
        return apiClient.zzb((zzlx.zza)new zzt.zza(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzsF().zza(new zzbt((zzlx.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<BooleanResult> isAutobackupEnabled(GoogleApiClient apiClient) {
        return apiClient.zza((zzlx.zza)new zzt<BooleanResult>(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                final 5 var2_2 = this;
                zzu2.zzsF().zze(new com.google.android.gms.drive.internal.zzd(){

                    @Override
                    public void zzac(boolean bl) {
                        var2_2.zzb((Result)new BooleanResult(Status.zzaeX, bl));
                    }
                });
            }

            protected BooleanResult zzB(Status status) {
                return new BooleanResult(status, false);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzB(status);
            }
        });
    }

    @Override
    public OpenFileActivityBuilder newOpenFileActivityBuilder() {
        return new OpenFileActivityBuilder();
    }

    @Override
    public CreateFileActivityBuilder newCreateFileActivityBuilder() {
        return new CreateFileActivityBuilder();
    }

    @Override
    public PendingResult<Status> cancelPendingActions(GoogleApiClient apiClient, List<String> trackingTags) {
        zzu zzu2 = (zzu)apiClient.zza(Drive.zzTo);
        return zzu2.cancelPendingActions(apiClient, trackingTags);
    }

    private static class zzi
    extends com.google.android.gms.drive.internal.zzd {
        private final zzlx.zzb<DriveApi.MetadataBufferResult> zzakL;

        public zzi(zzlx.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.zzakL = zzb2;
        }

        @Override
        public void zza(OnListEntriesResponse onListEntriesResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListEntriesResponse.zzsU());
            this.zzakL.zzr((Object)new zzg(Status.zzaeX, metadataBuffer, onListEntriesResponse.zzsV()));
        }

        @Override
        public void zzA(Status status) throws RemoteException {
            this.zzakL.zzr((Object)new zzg(status, null, false));
        }
    }

    static class zzg
    implements DriveApi.MetadataBufferResult {
        private final Status zzTA;
        private final MetadataBuffer zzaoF;
        private final boolean zzaoG;

        public zzg(Status status, MetadataBuffer metadataBuffer, boolean bl) {
            this.zzTA = status;
            this.zzaoF = metadataBuffer;
            this.zzaoG = bl;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public MetadataBuffer getMetadataBuffer() {
            return this.zzaoF;
        }

        public void release() {
            if (this.zzaoF != null) {
                this.zzaoF.release();
            }
        }
    }

    static abstract class zzh
    extends zzt<DriveApi.MetadataBufferResult> {
        zzh(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.MetadataBufferResult zzE(Status status) {
            return new zzg(status, null, false);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzE(status);
        }
    }

    static class zzd
    extends com.google.android.gms.drive.internal.zzd {
        private final zzlx.zzb<DriveApi.DriveIdResult> zzakL;

        public zzd(zzlx.zzb<DriveApi.DriveIdResult> zzb2) {
            this.zzakL = zzb2;
        }

        @Override
        public void zza(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.zzakL.zzr((Object)new zze(Status.zzaeX, new zzp(onMetadataResponse.zzsX()).getDriveId()));
        }

        @Override
        public void zza(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.zzakL.zzr((Object)new zze(Status.zzaeX, onDriveIdResponse.getDriveId()));
        }

        @Override
        public void zzA(Status status) throws RemoteException {
            this.zzakL.zzr((Object)new zze(status, null));
        }
    }

    private static class zze
    implements DriveApi.DriveIdResult {
        private final Status zzTA;
        private final DriveId zzamF;

        public zze(Status status, DriveId driveId) {
            this.zzTA = status;
            this.zzamF = driveId;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public DriveId getDriveId() {
            return this.zzamF;
        }
    }

    static abstract class zzf
    extends zzt<DriveApi.DriveIdResult> {
        zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveIdResult zzD(Status status) {
            return new zze(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzD(status);
        }
    }

    private static class zza
    extends com.google.android.gms.drive.internal.zzd {
        private final zzlx.zzb<DriveApi.DriveContentsResult> zzakL;

        public zza(zzlx.zzb<DriveApi.DriveContentsResult> zzb2) {
            this.zzakL = zzb2;
        }

        @Override
        public void zza(OnContentsResponse onContentsResponse) throws RemoteException {
            this.zzakL.zzr((Object)new zzb(Status.zzaeX, new zzv(onContentsResponse.zzsO())));
        }

        @Override
        public void zzA(Status status) throws RemoteException {
            this.zzakL.zzr((Object)new zzb(status, null));
        }
    }

    static class zzb
    implements Releasable,
    DriveApi.DriveContentsResult {
        private final Status zzTA;
        private final DriveContents zzamI;

        public zzb(Status status, DriveContents driveContents) {
            this.zzTA = status;
            this.zzamI = driveContents;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public DriveContents getDriveContents() {
            return this.zzamI;
        }

        public void release() {
            if (this.zzamI != null) {
                this.zzamI.zzsi();
            }
        }
    }

    static abstract class zzc
    extends zzt<DriveApi.DriveContentsResult> {
        zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveContentsResult zzC(Status status) {
            return new zzb(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzC(status);
        }
    }

    static class zzj
    extends zzt.zza {
        zzj(GoogleApiClient googleApiClient, Status status) {
            super(googleApiClient);
            this.zzb((Result)status);
        }

        protected void zza(zzu zzu2) {
        }
    }
}

