/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CloseContentsAndUpdateMetadataRequest;
import com.google.android.gms.drive.internal.CloseContentsRequest;
import com.google.android.gms.drive.internal.OpenContentsRequest;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzbl;
import com.google.android.gms.drive.internal.zzbt;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zznt;
import java.io.InputStream;
import java.io.OutputStream;

public class zzv
implements DriveContents {
    private final Contents zzaoW;
    private boolean mClosed = false;
    private boolean zzaoX = false;
    private boolean zzaoY = false;

    public zzv(Contents contents) {
        this.zzaoW = (Contents)zzx.zzy((Object)contents);
    }

    @Override
    public DriveId getDriveId() {
        return this.zzaoW.getDriveId();
    }

    @Override
    public int getMode() {
        return this.zzaoW.getMode();
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() {
        if (this.zzsj()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        return this.zzaoW.getParcelFileDescriptor();
    }

    @Override
    public InputStream getInputStream() {
        if (this.zzsj()) {
            throw new IllegalStateException("Contents have been closed, cannot access the input stream.");
        }
        if (this.zzaoW.getMode() != 0x10000000) {
            throw new IllegalStateException("getInputStream() can only be used with contents opened with MODE_READ_ONLY.");
        }
        if (this.zzaoX) {
            throw new IllegalStateException("getInputStream() can only be called once per Contents instance.");
        }
        this.zzaoX = true;
        return this.zzaoW.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.zzsj()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        if (this.zzaoW.getMode() != 0x20000000) {
            throw new IllegalStateException("getOutputStream() can only be used with contents opened with MODE_WRITE_ONLY.");
        }
        if (this.zzaoY) {
            throw new IllegalStateException("getOutputStream() can only be called once per Contents instance.");
        }
        this.zzaoY = true;
        return this.zzaoW.getOutputStream();
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> reopenForWrite(GoogleApiClient apiClient) {
        if (this.zzsj()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.zzaoW.getMode() != 0x10000000) {
            throw new IllegalStateException("reopenForWrite can only be used with DriveContents opened with MODE_READ_ONLY.");
        }
        this.zzsi();
        return apiClient.zza((zzlx.zza)new zzs.zzc(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzsF().zza(new OpenContentsRequest(zzv.this.getDriveId(), 0x20000000, zzv.this.zzaoW.getRequestId()), (zzan)new zzbl((zzlx.zzb<DriveApi.DriveContentsResult>)this, null));
            }
        });
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient apiClient, MetadataChangeSet changeSet) {
        return this.commit(apiClient, changeSet, null);
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient apiClient, MetadataChangeSet changeSet, ExecutionOptions executionOptions) {
        if (executionOptions == null) {
            executionOptions = new ExecutionOptions.Builder().build();
        }
        if (this.zzaoW.getMode() == 0x10000000) {
            throw new IllegalStateException("Cannot commit contents opened with MODE_READ_ONLY");
        }
        if (ExecutionOptions.zzcy(executionOptions.zzsn()) && !this.zzaoW.zzsf()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        ExecutionOptions.zza(apiClient, executionOptions);
        if (this.zzsj()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.getDriveId() == null) {
            throw new IllegalStateException("Only DriveContents obtained through DriveFile.open can be committed.");
        }
        final MetadataChangeSet metadataChangeSet = changeSet != null ? changeSet : MetadataChangeSet.zzanh;
        final ExecutionOptions executionOptions2 = executionOptions;
        this.zzsi();
        return apiClient.zzb((zzlx.zza)new zzt.zza(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                metadataChangeSet.zzsp().setContext(zzu2.getContext());
                zzu2.zzsF().zza(new CloseContentsAndUpdateMetadataRequest(zzv.this.zzaoW.getDriveId(), metadataChangeSet.zzsp(), zzv.this.zzaoW.getRequestId(), zzv.this.zzaoW.zzsf(), executionOptions2), (zzan)new zzbt((zzlx.zzb<Status>)this));
            }
        });
    }

    @Override
    public void discard(GoogleApiClient apiClient) {
        if (this.zzsj()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        this.zzsi();
        (apiClient.zzb((zzlx.zza)new zzt.zza(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzsF().zza(new CloseContentsRequest(zzv.this.zzaoW.getRequestId(), false), (zzan)new zzbt((zzlx.zzb<Status>)this));
            }
        })).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void zzp(Status status) {
                if (!status.isSuccess()) {
                    zzz.zzB("DriveContentsImpl", "Error discarding contents");
                } else {
                    zzz.zzz("DriveContentsImpl", "Contents discarded");
                }
            }

            public /* synthetic */ void onResult(Result x0) {
                this.zzp((Status)x0);
            }
        });
    }

    @Override
    public Contents zzsh() {
        return this.zzaoW;
    }

    @Override
    public void zzsi() {
        zznt.zza((ParcelFileDescriptor)this.zzaoW.getParcelFileDescriptor());
        this.mClosed = true;
    }

    @Override
    public boolean zzsj() {
        return this.mClosed;
    }
}

