/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CreateFileRequest;
import com.google.android.gms.drive.internal.CreateFolderRequest;
import com.google.android.gms.drive.internal.OnDriveIdResponse;
import com.google.android.gms.drive.internal.zzab;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.internal.zzv;
import com.google.android.gms.drive.internal.zzw;
import com.google.android.gms.drive.query.Filters;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.drive.query.SearchableField;
import com.google.android.gms.internal.zzlx;

public class zzy
extends zzab
implements DriveFolder {
    public zzy(DriveId driveId) {
        super(driveId);
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listChildren(GoogleApiClient apiClient) {
        return this.queryChildren(apiClient, null);
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> queryChildren(GoogleApiClient apiClient, Query query) {
        return new zzs().query(apiClient, this.zza(query));
    }

    private Query zza(Query query) {
        Query.Builder builder = new Query.Builder().addFilter(Filters.in(SearchableField.PARENTS, this.getDriveId()));
        if (query != null) {
            if (query.getFilter() != null) {
                builder.addFilter(query.getFilter());
            }
            builder.setPageToken(query.getPageToken());
            builder.setSortOrder(query.getSortOrder());
        }
        return builder.build();
    }

    @Override
    public PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient apiClient, MetadataChangeSet changeSet, DriveContents driveContents) {
        return this.createFile(apiClient, changeSet, driveContents, null);
    }

    @Override
    public PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient apiClient, MetadataChangeSet changeSet, DriveContents driveContents, ExecutionOptions executionOptions) {
        if (executionOptions == null) {
            executionOptions = new ExecutionOptions.Builder().build();
        }
        if (executionOptions.zzsn() != 0) {
            throw new IllegalStateException("May not set a conflict strategy for calls to createFile.");
        }
        return this.zza(apiClient, changeSet, driveContents, executionOptions);
    }

    private PendingResult<DriveFolder.DriveFileResult> zza(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, ExecutionOptions executionOptions) {
        int n;
        if (driveContents != null) {
            if (!(driveContents instanceof zzv)) {
                throw new IllegalArgumentException("Only DriveContents obtained from the Drive API are accepted.");
            }
            if (driveContents.getDriveId() != null) {
                throw new IllegalArgumentException("Only DriveContents obtained through DriveApi.newDriveContents are accepted for file creation.");
            }
            if (driveContents.zzsj()) {
                throw new IllegalArgumentException("DriveContents are already closed.");
            }
            n = driveContents.zzsh().getRequestId();
            driveContents.zzsi();
        } else {
            n = 1;
        }
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        if ("application/vnd.google-apps.folder".equals(metadataChangeSet.getMimeType())) {
            throw new IllegalArgumentException("May not create folders (mimetype: application/vnd.google-apps.folder) using this method. Use DriveFolder.createFolder() instead.");
        }
        return this.zza(googleApiClient, metadataChangeSet, n, 0, executionOptions);
    }

    private PendingResult<DriveFolder.DriveFileResult> zza(GoogleApiClient googleApiClient, final MetadataChangeSet metadataChangeSet, final int n, final int n2, final ExecutionOptions executionOptions) {
        ExecutionOptions.zza(googleApiClient, executionOptions);
        return googleApiClient.zzb((zzlx.zza)new zzd(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                metadataChangeSet.zzsp().setContext(zzu2.getContext());
                CreateFileRequest createFileRequest = new CreateFileRequest(zzy.this.getDriveId(), metadataChangeSet.zzsp(), n, n2, executionOptions);
                zzu2.zzsF().zza(createFileRequest, (zzan)new zza((zzlx.zzb<DriveFolder.DriveFileResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveFolder.DriveFolderResult> createFolder(GoogleApiClient apiClient, final MetadataChangeSet changeSet) {
        if (changeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        if (changeSet.getMimeType() != null && !changeSet.getMimeType().equals("application/vnd.google-apps.folder")) {
            throw new IllegalArgumentException("The mimetype must be of type application/vnd.google-apps.folder");
        }
        return apiClient.zzb((zzlx.zza)new zzf(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                changeSet.zzsp().setContext(zzu2.getContext());
                zzu2.zzsF().zza(new CreateFolderRequest(zzy.this.getDriveId(), changeSet.zzsp()), (zzan)new zzb((zzlx.zzb<DriveFolder.DriveFolderResult>)this));
            }
        });
    }

    private static class zzb
    extends com.google.android.gms.drive.internal.zzd {
        private final zzlx.zzb<DriveFolder.DriveFolderResult> zzakL;

        public zzb(zzlx.zzb<DriveFolder.DriveFolderResult> zzb2) {
            this.zzakL = zzb2;
        }

        @Override
        public void zza(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.zzakL.zzr((Object)new zze(Status.zzaeX, new zzy(onDriveIdResponse.getDriveId())));
        }

        @Override
        public void zzA(Status status) throws RemoteException {
            this.zzakL.zzr((Object)new zze(status, null));
        }
    }

    private static class zze
    implements DriveFolder.DriveFolderResult {
        private final Status zzTA;
        private final DriveFolder zzapo;

        public zze(Status status, DriveFolder driveFolder) {
            this.zzTA = status;
            this.zzapo = driveFolder;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public DriveFolder getDriveFolder() {
            return this.zzapo;
        }
    }

    static abstract class zzf
    extends zzt<DriveFolder.DriveFolderResult> {
        zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveFolder.DriveFolderResult zzG(Status status) {
            return new zze(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzG(status);
        }
    }

    private static class zza
    extends com.google.android.gms.drive.internal.zzd {
        private final zzlx.zzb<DriveFolder.DriveFileResult> zzakL;

        public zza(zzlx.zzb<DriveFolder.DriveFileResult> zzb2) {
            this.zzakL = zzb2;
        }

        @Override
        public void zza(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.zzakL.zzr((Object)new zzc(Status.zzaeX, new zzw(onDriveIdResponse.getDriveId())));
        }

        @Override
        public void zzA(Status status) throws RemoteException {
            this.zzakL.zzr((Object)new zzc(status, null));
        }
    }

    private static class zzc
    implements DriveFolder.DriveFileResult {
        private final Status zzTA;
        private final DriveFile zzapn;

        public zzc(Status status, DriveFile driveFile) {
            this.zzTA = status;
            this.zzapn = driveFile;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public DriveFile getDriveFile() {
            return this.zzapn;
        }
    }

    static abstract class zzd
    extends zzt<DriveFolder.DriveFileResult> {
        zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveFolder.DriveFileResult zzF(Status status) {
            return new zzc(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzF(status);
        }
    }
}

