/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.metadata;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.metadata.zzc;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomPropertyKey
implements SafeParcelable {
    public static final Parcelable.Creator<CustomPropertyKey> CREATOR = new zzc();
    public static final int PUBLIC = 0;
    public static final int PRIVATE = 1;
    final int mVersionCode;
    final String zzuX;
    final int mVisibility;
    private static final Pattern zzaqE = Pattern.compile("[\\w.!@$%^&*()/-]+");

    CustomPropertyKey(int versionCode, String key, int visibility) {
        zzx.zzb((Object)key, (Object)"key");
        zzx.zzb((boolean)zzaqE.matcher(key).matches(), (Object)"key name characters must be alphanumeric or one of .!@$%^&*()-_/");
        zzx.zzb((visibility == 0 || visibility == 1 ? 1 : 0) != 0, (Object)"visibility must be either PUBLIC or PRIVATE");
        this.mVersionCode = versionCode;
        this.zzuX = key;
        this.mVisibility = visibility;
    }

    public CustomPropertyKey(String key, int visibility) {
        this(1, key, visibility);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzc.zza(this, dest, flags);
    }

    public String getKey() {
        return this.zzuX;
    }

    public int getVisibility() {
        return this.mVisibility;
    }

    public int hashCode() {
        return (this.zzuX + this.mVisibility).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomPropertyKey)) {
            return false;
        }
        CustomPropertyKey customPropertyKey = (CustomPropertyKey)obj;
        return customPropertyKey.getKey().equals(this.zzuX) && customPropertyKey.getVisibility() == this.mVisibility;
    }

    public String toString() {
        return "CustomPropertyKey(" + this.zzuX + "," + this.mVisibility + ")";
    }

    public JSONObject toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("key", (Object)this.getKey());
        jSONObject.put("visibility", this.getVisibility());
        return jSONObject;
    }

    public static CustomPropertyKey fromJson(JSONObject jsonObject) throws JSONException {
        return new CustomPropertyKey(jsonObject.getString("key"), jsonObject.getInt("visibility"));
    }
}

