/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.metadata.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.zze;
import com.google.android.gms.drive.metadata.internal.zzh;
import com.google.android.gms.internal.zzof;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class MetadataBundle
implements SafeParcelable {
    public static final Parcelable.Creator<MetadataBundle> CREATOR = new zzh();
    final int mVersionCode;
    final Bundle zzaqL;

    MetadataBundle(int versionCode, Bundle valueBundle) {
        this.mVersionCode = versionCode;
        this.zzaqL = (Bundle)zzx.zzy((Object)valueBundle);
        this.zzaqL.setClassLoader(this.getClass().getClassLoader());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.zzaqL.keySet()) {
            if (zze.zzcU(string) != null) continue;
            arrayList.add(string);
            zzz.zzA("MetadataBundle", "Ignored unknown metadata field in bundle: " + string);
        }
        for (String string : arrayList) {
            this.zzaqL.remove(string);
        }
    }

    private MetadataBundle(Bundle valueBundle) {
        this(1, valueBundle);
    }

    public static MetadataBundle zztf() {
        return new MetadataBundle(new Bundle());
    }

    public static MetadataBundle zza(MetadataBundle metadataBundle) {
        return new MetadataBundle(new Bundle(metadataBundle.zzaqL));
    }

    public static <T> MetadataBundle zza(MetadataField<T> metadataField, T t) {
        MetadataBundle metadataBundle = MetadataBundle.zztf();
        metadataBundle.zzb(metadataField, t);
        return metadataBundle;
    }

    public <T> void zzb(MetadataField<T> metadataField, T t) {
        if (zze.zzcU(metadataField.getName()) == null) {
            throw new IllegalArgumentException("Unregistered field: " + metadataField.getName());
        }
        metadataField.zza(t, this.zzaqL);
    }

    public <T> T zza(MetadataField<T> metadataField) {
        return metadataField.zzm(this.zzaqL);
    }

    public boolean zzc(MetadataField<?> metadataField) {
        return this.zzaqL.containsKey(metadataField.getName());
    }

    public Set<MetadataField<?>> zztg() {
        HashSet hashSet = new HashSet();
        for (String string : this.zzaqL.keySet()) {
            hashSet.add(zze.zzcU(string));
        }
        return hashSet;
    }

    public void setContext(Context context) {
        BitmapTeleporter bitmapTeleporter = this.zza(zzof.zzart);
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(context.getCacheDir());
        }
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        for (String string : this.zzaqL.keySet()) {
            n2 = n2 * 31 + this.zzaqL.get(string).hashCode();
        }
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetadataBundle)) {
            return false;
        }
        MetadataBundle metadataBundle = (MetadataBundle)obj;
        Set set = this.zzaqL.keySet();
        if (!set.equals(metadataBundle.zzaqL.keySet())) {
            return false;
        }
        for (String string : set) {
            if (zzw.equal((Object)this.zzaqL.get(string), (Object)metadataBundle.zzaqL.get(string))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "MetadataBundle [values=" + this.zzaqL + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzh.zza(this, dest, flags);
    }
}

