/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.widget;

import android.content.Context;
import android.database.CursorIndexOutOfBoundsException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.drive.internal.zzz;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DataBufferAdapter<T>
extends BaseAdapter {
    private final Context mContext;
    private final int zzatm;
    private int zzatn;
    private final int zzato;
    private final List<DataBuffer<T>> zzatp;
    private final LayoutInflater mInflater;
    private boolean zzatq = true;

    public DataBufferAdapter(Context context, int resource, int textViewResourceId, List<DataBuffer<T>> objects) {
        this.mContext = context;
        this.zzatm = this.zzatn = resource;
        this.zzato = textViewResourceId;
        this.zzatp = objects;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public DataBufferAdapter(Context context, int resource, int textViewResourceId) {
        this(context, resource, textViewResourceId, new ArrayList<DataBuffer<T>>());
    }

    public DataBufferAdapter(Context context, int resource, List<DataBuffer<T>> objects) {
        this(context, resource, 0, objects);
    }

    public DataBufferAdapter(Context context, int resource) {
        this(context, resource, 0, new ArrayList<DataBuffer<T>>());
    }

    public DataBufferAdapter(Context context, int resource, int textViewResourceId, DataBuffer<T> ... buffers) {
        this(context, resource, textViewResourceId, Arrays.asList(buffers));
    }

    public DataBufferAdapter(Context context, int resource, DataBuffer<T> ... buffers) {
        this(context, resource, 0, Arrays.asList(buffers));
    }

    public void append(DataBuffer<T> buffer) {
        this.zzatp.add(buffer);
        if (this.zzatq) {
            this.notifyDataSetChanged();
        }
    }

    public void clear() {
        for (DataBuffer<T> dataBuffer : this.zzatp) {
            dataBuffer.release();
        }
        this.zzatp.clear();
        if (this.zzatq) {
            this.notifyDataSetChanged();
        }
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.zzatq = true;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.zzatq = notifyOnChange;
    }

    public Context getContext() {
        return this.mContext;
    }

    public int getCount() {
        int n = 0;
        for (DataBuffer<T> dataBuffer : this.zzatp) {
            n += dataBuffer.getCount();
        }
        return n;
    }

    public T getItem(int position) throws CursorIndexOutOfBoundsException {
        int n = position;
        for (DataBuffer<T> dataBuffer : this.zzatp) {
            int n2 = dataBuffer.getCount();
            if (n2 <= n) {
                n -= n2;
                continue;
            }
            try {
                return (T)dataBuffer.get(n);
            }
            catch (CursorIndexOutOfBoundsException cursorIndexOutOfBoundsException) {
                throw new CursorIndexOutOfBoundsException(position, this.getCount());
            }
        }
        throw new CursorIndexOutOfBoundsException(position, this.getCount());
    }

    public long getItemId(int position) {
        return position;
    }

    private View zza(int n, View view, ViewGroup viewGroup, int n2) {
        TextView textView;
        View view2 = view == null ? this.mInflater.inflate(n2, viewGroup, false) : view;
        try {
            textView = this.zzato == 0 ? (TextView)view2 : (TextView)view2.findViewById(this.zzato);
        }
        catch (ClassCastException classCastException) {
            zzz.zza("DataBufferAdapter", classCastException, "You must supply a resource ID for a TextView");
            throw new IllegalStateException("DataBufferAdapter requires the resource ID to be a TextView", classCastException);
        }
        T t = this.getItem(n);
        if (t instanceof CharSequence) {
            textView.setText((CharSequence)t);
        } else {
            textView.setText((CharSequence)t.toString());
        }
        return view2;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.zza(position, convertView, parent, this.zzatm);
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return this.zza(position, convertView, parent, this.zzatn);
    }

    public void setDropDownViewResource(int resource) {
        this.zzatn = resource;
    }
}

