/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Pair;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.ChangesAvailableEvent;
import com.google.android.gms.drive.events.CompletionEvent;
import com.google.android.gms.drive.events.CompletionListener;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.events.QueryResultEventParcelable;
import com.google.android.gms.drive.events.TransferProgressEvent;
import com.google.android.gms.drive.events.internal.TransferProgressData;
import com.google.android.gms.drive.events.zzc;
import com.google.android.gms.drive.events.zzf;
import com.google.android.gms.drive.events.zzi;
import com.google.android.gms.drive.events.zzk;
import com.google.android.gms.drive.events.zzm;
import com.google.android.gms.drive.internal.OnEventResponse;
import com.google.android.gms.drive.internal.zzao;
import com.google.android.gms.drive.internal.zzz;
import java.util.ArrayList;
import java.util.List;

public class zzae
extends zzao.zza {
    private final int zzanf;
    private final zzf zzarC;
    private final zza zzarD;
    private final List<Integer> zzarE = new ArrayList<Integer>();

    public zzae(Looper looper, Context context, int n, zzf zzf2) {
        this.zzanf = n;
        this.zzarC = zzf2;
        this.zzarD = new zza(looper, context);
    }

    public void zzdg(int n) {
        this.zzarE.add(n);
    }

    public boolean zzdh(int n) {
        return this.zzarE.contains(n);
    }

    @Override
    public void zzc(OnEventResponse onEventResponse) throws RemoteException {
        DriveEvent driveEvent = onEventResponse.zzts();
        zzx.zzab((this.zzanf == driveEvent.getType() ? 1 : 0) != 0);
        zzx.zzab((boolean)this.zzarE.contains(driveEvent.getType()));
        this.zzarD.zza(this.zzarC, driveEvent);
    }

    private static class zza
    extends Handler {
        private final Context mContext;

        private zza(Looper looper, Context context) {
            super(looper);
            this.mContext = context;
        }

        public void zza(zzf zzf2, DriveEvent driveEvent) {
            this.sendMessage(this.obtainMessage(1, new Pair((Object)zzf2, (Object)driveEvent)));
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    zzf zzf2 = (zzf)pair.first;
                    DriveEvent driveEvent = (DriveEvent)pair.second;
                    switch (driveEvent.getType()) {
                        case 1: {
                            ((ChangeListener)zzf2).onChange((ChangeEvent)driveEvent);
                            break;
                        }
                        case 2: {
                            ((CompletionListener)zzf2).onCompletion((CompletionEvent)driveEvent);
                            break;
                        }
                        case 3: {
                            zza.zza((zzm)zzf2, (QueryResultEventParcelable)driveEvent);
                            break;
                        }
                        case 4: {
                            ((zzc)zzf2).zza((ChangesAvailableEvent)driveEvent);
                            break;
                        }
                        case 8: {
                            TransferProgressData transferProgressData = ((TransferProgressEvent)driveEvent).zzta();
                            com.google.android.gms.drive.events.internal.zza zza2 = new com.google.android.gms.drive.events.internal.zza(transferProgressData);
                            ((zzi)zzf2).zza(zza2);
                            break;
                        }
                        default: {
                            zzz.zzz("EventCallback", "Unexpected event: " + driveEvent);
                        }
                    }
                    return;
                }
            }
            zzz.zze(this.mContext, "EventCallback", "Don't know how to handle this event");
        }

        private static void zza(zzm zzm2, QueryResultEventParcelable queryResultEventParcelable) {
            DataHolder dataHolder = queryResultEventParcelable.zzsX();
            if (dataHolder != null) {
                final MetadataBuffer metadataBuffer = new MetadataBuffer(dataHolder);
                zzm2.zza(new zzk(){});
            }
            if (queryResultEventParcelable.zzsY()) {
                zzm2.zzcJ(queryResultEventParcelable.zzsZ());
            }
        }
    }
}

