/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.internal.zzab;
import com.google.android.gms.drive.internal.zzw;
import com.google.android.gms.drive.internal.zzy;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.drive.zze;
import com.google.android.gms.internal.zzami;
import com.google.android.gms.internal.zzamj;
import com.google.android.gms.internal.zzqb;
import com.google.android.gms.internal.zzqc;

public class DriveId
extends AbstractSafeParcelable {
    public static final int RESOURCE_TYPE_UNKNOWN = -1;
    public static final int RESOURCE_TYPE_FILE = 0;
    public static final int RESOURCE_TYPE_FOLDER = 1;
    public static final Parcelable.Creator<DriveId> CREATOR = new zze();
    final int mVersionCode;
    final String zzavl;
    final long zzavm;
    final long zzauU;
    final int zzavn;
    private volatile String zzauW = null;
    private volatile String zzavo = null;

    public static DriveId zzdw(String string) {
        zzaa.zzz((Object)string);
        return new DriveId(string, -1L, -1L, -1);
    }

    public String getResourceId() {
        return this.zzavl;
    }

    public int getResourceType() {
        return this.zzavn;
    }

    public DriveFile asDriveFile() {
        if (this.zzavn == 1) {
            throw new IllegalStateException("This DriveId corresponds to a folder. Call asDriveFolder instead.");
        }
        return new zzw(this);
    }

    public DriveFolder asDriveFolder() {
        if (this.zzavn == 0) {
            throw new IllegalStateException("This DriveId corresponds to a file. Call asDriveFile instead.");
        }
        return new zzy(this);
    }

    public DriveResource asDriveResource() {
        if (this.zzavn == 1) {
            return this.asDriveFolder();
        }
        if (this.zzavn == 0) {
            return this.asDriveFile();
        }
        return new zzab(this);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }

    DriveId(int n, String string, long l, long l2, int n2) {
        this.mVersionCode = n;
        this.zzavl = string;
        zzaa.zzaj((!"".equals(string) ? 1 : 0) != 0);
        zzaa.zzaj((string != null || l != -1L ? 1 : 0) != 0);
        this.zzavm = l;
        this.zzauU = l2;
        this.zzavn = n2;
    }

    public DriveId(String string, long l, long l2, int n) {
        this(1, string, l, l2, n);
    }

    public int hashCode() {
        if (this.zzavm == -1L) {
            return this.zzavl.hashCode();
        }
        String string = String.valueOf(String.valueOf(this.zzauU));
        String string2 = String.valueOf(String.valueOf(this.zzavm));
        return (string2.length() != 0 ? string.concat(string2) : new String(string)).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DriveId)) {
            return false;
        }
        DriveId driveId = (DriveId)((Object)object);
        if (driveId.zzauU != this.zzauU) {
            return false;
        }
        if (driveId.zzavm == -1L && this.zzavm == -1L) {
            return driveId.zzavl.equals(this.zzavl);
        }
        if (this.zzavl == null || driveId.zzavl == null) {
            return driveId.zzavm == this.zzavm;
        }
        if (driveId.zzavm == this.zzavm) {
            if (driveId.zzavl.equals(this.zzavl)) {
                return true;
            }
            zzz.zzD("DriveId", "Unexpected unequal resourceId for same DriveId object.");
        }
        return false;
    }

    public final String encodeToString() {
        if (this.zzauW == null) {
            byte[] byArray = this.zzvD();
            String string = Base64.encodeToString((byte[])byArray, (int)10);
            String string2 = String.valueOf("DriveId:");
            String string3 = String.valueOf(string);
            this.zzauW = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        return this.zzauW;
    }

    public final String toInvariantString() {
        if (this.zzavo == null) {
            byte[] byArray = this.zzvJ();
            this.zzavo = Base64.encodeToString((byte[])byArray, (int)10);
        }
        return this.zzavo;
    }

    final byte[] zzvD() {
        zzqb zzqb2 = new zzqb();
        zzqb2.versionCode = this.mVersionCode;
        zzqb2.zzazd = this.zzavl == null ? "" : this.zzavl;
        zzqb2.zzaze = this.zzavm;
        zzqb2.zzazb = this.zzauU;
        zzqb2.zzazf = this.zzavn;
        byte[] byArray = zzamj.toByteArray((zzamj)zzqb2);
        return byArray;
    }

    private byte[] zzvJ() {
        zzqc zzqc2 = new zzqc();
        zzqc2.zzaze = this.zzavm;
        zzqc2.zzazb = this.zzauU;
        byte[] byArray = zzamj.toByteArray((zzamj)zzqc2);
        return byArray;
    }

    public String toString() {
        return this.encodeToString();
    }

    public static DriveId decodeFromString(String string) {
        String string2 = String.valueOf(string);
        zzaa.zzb((boolean)string.startsWith("DriveId:"), (Object)(string2.length() != 0 ? "Invalid DriveId: ".concat(string2) : new String("Invalid DriveId: ")));
        String string3 = string.substring("DriveId:".length());
        byte[] byArray = Base64.decode((String)string3, (int)10);
        return DriveId.zzn(byArray);
    }

    static DriveId zzn(byte[] byArray) {
        zzqb zzqb2;
        try {
            zzqb2 = zzqb.zzo(byArray);
        }
        catch (zzami zzami2) {
            throw new IllegalArgumentException();
        }
        String string = "".equals(zzqb2.zzazd) ? null : zzqb2.zzazd;
        DriveId driveId = new DriveId(zzqb2.versionCode, string, zzqb2.zzaze, zzqb2.zzazb, zzqb2.zzazf);
        return driveId;
    }
}

