/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzqd;
import com.google.android.gms.internal.zzqf;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public final class MetadataChangeSet {
    public static final int INDEXABLE_TEXT_SIZE_LIMIT_BYTES = 131072;
    public static final int CUSTOM_PROPERTY_SIZE_LIMIT_BYTES = 124;
    public static final int MAX_PUBLIC_PROPERTIES_PER_RESOURCE = 30;
    public static final int MAX_PRIVATE_PROPERTIES_PER_RESOURCE_PER_APP = 30;
    public static final int MAX_TOTAL_PROPERTIES_PER_RESOURCE = 100;
    public static final MetadataChangeSet zzavD = new MetadataChangeSet(MetadataBundle.zzwN());
    private final MetadataBundle zzavE;

    public MetadataChangeSet(MetadataBundle metadataBundle) {
        this.zzavE = metadataBundle.zzwO();
    }

    public Map<CustomPropertyKey, String> getCustomPropertyChangeMap() {
        AppVisibleCustomProperties appVisibleCustomProperties = this.zzavE.zza(zzqd.zzazx);
        return appVisibleCustomProperties == null ? Collections.emptyMap() : appVisibleCustomProperties.zzwI();
    }

    public String getDescription() {
        return this.zzavE.zza(zzqd.zzazy);
    }

    public String getIndexableText() {
        return this.zzavE.zza(zzqd.zzazE);
    }

    public Date getLastViewedByMeDate() {
        return this.zzavE.zza(zzqf.zzaAo);
    }

    public String getMimeType() {
        return this.zzavE.zza(zzqd.zzazS);
    }

    public String getTitle() {
        return this.zzavE.zza(zzqd.zzaAb);
    }

    public Boolean isPinned() {
        return this.zzavE.zza(zzqd.zzazK);
    }

    public Boolean isStarred() {
        return this.zzavE.zza(zzqd.zzazZ);
    }

    public Boolean isViewed() {
        return this.zzavE.zza(zzqd.zzazR);
    }

    public MetadataBundle zzvU() {
        return this.zzavE;
    }

    public MetadataChangeSet zzvV() {
        return new MetadataChangeSet(this.zzvU());
    }

    public <T> MetadataChangeSet zza(MetadataField<T> metadataField, T t) {
        MetadataChangeSet metadataChangeSet = this.zzvV();
        metadataChangeSet.zzvU().zzc(metadataField, t);
        return metadataChangeSet;
    }

    public static class Builder {
        private final MetadataBundle zzavE = MetadataBundle.zzwN();
        private AppVisibleCustomProperties.zza zzavF;

        private AppVisibleCustomProperties.zza zzvW() {
            if (this.zzavF == null) {
                this.zzavF = new AppVisibleCustomProperties.zza();
            }
            return this.zzavF;
        }

        private int zzdA(String string) {
            return string == null ? 0 : string.getBytes().length;
        }

        private String zzj(String string, int n, int n2) {
            return String.format("%s must be no more than %d bytes, but is %d bytes.", string, n, n2);
        }

        private void zzk(String string, int n, int n2) {
            zzaa.zzb((n2 <= n ? 1 : 0) != 0, (Object)this.zzj(string, n, n2));
        }

        public Builder setCustomProperty(CustomPropertyKey customPropertyKey, String string) {
            zzaa.zzb((Object)((Object)customPropertyKey), (Object)"key");
            zzaa.zzb((Object)string, (Object)"value");
            int n = this.zzdA(customPropertyKey.getKey()) + this.zzdA(string);
            this.zzk("The total size of key string and value string of a custom property", 124, n);
            this.zzvW().zza(customPropertyKey, string);
            return this;
        }

        public Builder deleteCustomProperty(CustomPropertyKey customPropertyKey) {
            zzaa.zzb((Object)((Object)customPropertyKey), (Object)"key");
            this.zzvW().zza(customPropertyKey, null);
            return this;
        }

        public Builder setDescription(String string) {
            this.zzavE.zzc(zzqd.zzazy, string);
            return this;
        }

        public Builder setIndexableText(String string) {
            int n = this.zzdA(string);
            this.zzk("Indexable text size", 131072, n);
            this.zzavE.zzc(zzqd.zzazE, string);
            return this;
        }

        public Builder setLastViewedByMeDate(Date date) {
            this.zzavE.zzc(zzqf.zzaAo, date);
            return this;
        }

        public Builder setMimeType(String string) {
            this.zzavE.zzc(zzqd.zzazS, string);
            return this;
        }

        public Builder setPinned(boolean bl) {
            this.zzavE.zzc(zzqd.zzazK, bl);
            return this;
        }

        public Builder setStarred(boolean bl) {
            this.zzavE.zzc(zzqd.zzazZ, bl);
            return this;
        }

        public Builder setTitle(String string) {
            this.zzavE.zzc(zzqd.zzaAb, string);
            return this;
        }

        public Builder setViewed(boolean bl) {
            this.zzavE.zzc(zzqd.zzazR, bl);
            return this;
        }

        public MetadataChangeSet build() {
            if (this.zzavF != null) {
                this.zzavE.zzc(zzqd.zzazx, this.zzavF.zzwJ());
            }
            return new MetadataChangeSet(this.zzavE);
        }
    }
}

