/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.annotation.SuppressLint;
import android.os.RemoteException;
import com.google.android.gms.common.api.BooleanResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.CreateFileActivityBuilder;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.OpenFileActivityBuilder;
import com.google.android.gms.drive.internal.CreateContentsRequest;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.OnContentsResponse;
import com.google.android.gms.drive.internal.OnDriveIdResponse;
import com.google.android.gms.drive.internal.OnListEntriesResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.QueryRequest;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzbr;
import com.google.android.gms.drive.internal.zzp;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.internal.zzv;
import com.google.android.gms.drive.internal.zzw;
import com.google.android.gms.drive.internal.zzy;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.internal.zznt;
import java.util.List;

public class zzs
implements DriveApi {
    @Override
    public PendingResult<DriveApi.MetadataBufferResult> query(GoogleApiClient googleApiClient, final Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be provided.");
        }
        return googleApiClient.zzc((zznt.zza)new zzh(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzwn().zza(new QueryRequest(query), (zzan)new zzi((zznt.zzb<DriveApi.MetadataBufferResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> newDriveContents(GoogleApiClient googleApiClient) {
        return this.zza(googleApiClient, 0x20000000);
    }

    public PendingResult<DriveApi.DriveContentsResult> zza(GoogleApiClient googleApiClient, final int n) {
        return googleApiClient.zzc((zznt.zza)new zzc(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzwn().zza(new CreateContentsRequest(n), (zzan)new zza((zznt.zzb<DriveApi.DriveContentsResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveIdResult> fetchDriveId(GoogleApiClient googleApiClient, final String string) {
        return googleApiClient.zzc((zznt.zza)new zzf(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzwn().zza(new GetMetadataRequest(DriveId.zzdw(string), false), (zzan)new zzd((zznt.zzb<DriveApi.DriveIdResult>)this));
            }
        });
    }

    @Override
    public DriveFile getFile(GoogleApiClient googleApiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!googleApiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzw(driveId);
    }

    @Override
    public DriveFolder getFolder(GoogleApiClient googleApiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!googleApiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzy(driveId);
    }

    @Override
    public DriveFolder getRootFolder(GoogleApiClient googleApiClient) {
        zzu zzu2 = (zzu)googleApiClient.zza(Drive.zzaaz);
        if (!zzu2.zzwq()) {
            throw new IllegalStateException("Client is not yet connected");
        }
        DriveId driveId = zzu2.zzwo();
        return driveId != null ? new zzy(driveId) : null;
    }

    @Override
    public DriveFolder getAppFolder(GoogleApiClient googleApiClient) {
        zzu zzu2 = (zzu)googleApiClient.zza(Drive.zzaaz);
        if (!zzu2.zzwq()) {
            throw new IllegalStateException("Client is not yet connected");
        }
        DriveId driveId = zzu2.zzwp();
        return driveId != null ? new zzy(driveId) : null;
    }

    @Override
    public PendingResult<Status> requestSync(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zznt.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzwn().zza(new zzbr((zznt.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<BooleanResult> isAutobackupEnabled(GoogleApiClient googleApiClient) {
        return googleApiClient.zzc((zznt.zza)new zzt<BooleanResult>(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                final 5 var2_2 = this;
                zzu2.zzwn().zze(new com.google.android.gms.drive.internal.zzd(){

                    @Override
                    public void zzam(boolean bl) {
                        var2_2.zzb((Result)new BooleanResult(Status.zzalw, bl));
                    }
                });
            }

            protected BooleanResult zzE(Status status) {
                return new BooleanResult(status, false);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzE(status);
            }
        });
    }

    @Override
    public OpenFileActivityBuilder newOpenFileActivityBuilder() {
        return new OpenFileActivityBuilder();
    }

    @Override
    public CreateFileActivityBuilder newCreateFileActivityBuilder() {
        return new CreateFileActivityBuilder();
    }

    @Override
    public PendingResult<Status> cancelPendingActions(GoogleApiClient googleApiClient, List<String> list) {
        zzu zzu2 = (zzu)googleApiClient.zza(Drive.zzaaz);
        return zzu2.cancelPendingActions(googleApiClient, list);
    }

    private static class zzi
    extends com.google.android.gms.drive.internal.zzd {
        private final zznt.zzb<DriveApi.MetadataBufferResult> zzasz;

        public zzi(zznt.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.zzasz = zzb2;
        }

        @Override
        public void zza(OnListEntriesResponse onListEntriesResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListEntriesResponse.zzwz());
            this.zzasz.setResult((Object)new zzg(Status.zzalw, metadataBuffer, onListEntriesResponse.zzwA()));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzasz.setResult((Object)new zzg(status, null, false));
        }
    }

    static class zzg
    implements DriveApi.MetadataBufferResult {
        private final Status zzaaO;
        private final MetadataBuffer zzaxi;
        private final boolean zzaxj;

        public zzg(Status status, MetadataBuffer metadataBuffer, boolean bl) {
            this.zzaaO = status;
            this.zzaxi = metadataBuffer;
            this.zzaxj = bl;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public MetadataBuffer getMetadataBuffer() {
            return this.zzaxi;
        }

        public void release() {
            if (this.zzaxi != null) {
                this.zzaxi.release();
            }
        }
    }

    static abstract class zzh
    extends zzt<DriveApi.MetadataBufferResult> {
        zzh(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.MetadataBufferResult zzH(Status status) {
            return new zzg(status, null, false);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzH(status);
        }
    }

    static class zzd
    extends com.google.android.gms.drive.internal.zzd {
        private final zznt.zzb<DriveApi.DriveIdResult> zzasz;

        public zzd(zznt.zzb<DriveApi.DriveIdResult> zzb2) {
            this.zzasz = zzb2;
        }

        @Override
        public void zza(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.zzasz.setResult((Object)new zze(Status.zzalw, new zzp(onMetadataResponse.zzwC()).getDriveId()));
        }

        @Override
        public void zza(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.zzasz.setResult((Object)new zze(Status.zzalw, onDriveIdResponse.getDriveId()));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzasz.setResult((Object)new zze(status, null));
        }
    }

    private static class zze
    implements DriveApi.DriveIdResult {
        private final Status zzaaO;
        private final DriveId zzauZ;

        public zze(Status status, DriveId driveId) {
            this.zzaaO = status;
            this.zzauZ = driveId;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public DriveId getDriveId() {
            return this.zzauZ;
        }
    }

    static abstract class zzf
    extends zzt<DriveApi.DriveIdResult> {
        zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveIdResult zzG(Status status) {
            return new zze(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzG(status);
        }
    }

    private static class zza
    extends com.google.android.gms.drive.internal.zzd {
        private final zznt.zzb<DriveApi.DriveContentsResult> zzasz;

        public zza(zznt.zzb<DriveApi.DriveContentsResult> zzb2) {
            this.zzasz = zzb2;
        }

        @Override
        public void zza(OnContentsResponse onContentsResponse) throws RemoteException {
            this.zzasz.setResult((Object)new zzb(Status.zzalw, new zzv(onContentsResponse.zzwt())));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzasz.setResult((Object)new zzb(status, null));
        }
    }

    static class zzb
    implements Releasable,
    DriveApi.DriveContentsResult {
        private final Status zzaaO;
        private final DriveContents zzavc;

        public zzb(Status status, DriveContents driveContents) {
            this.zzaaO = status;
            this.zzavc = driveContents;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public DriveContents getDriveContents() {
            return this.zzavc;
        }

        public void release() {
            if (this.zzavc != null) {
                this.zzavc.zzvH();
            }
        }
    }

    static abstract class zzc
    extends zzt<DriveApi.DriveContentsResult> {
        zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveContentsResult zzF(Status status) {
            return new zzb(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzF(status);
        }
    }

    @SuppressLint(value={"MissingRemoteException"})
    static class zzj
    extends zzt.zza {
        zzj(GoogleApiClient googleApiClient, Status status) {
            super(googleApiClient);
            this.zzb((Result)status);
        }

        protected void zza(zzu zzu2) {
        }
    }
}

