/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.zzc;
import com.google.android.gms.drive.events.zzi;
import com.google.android.gms.drive.internal.AddEventListenerRequest;
import com.google.android.gms.drive.internal.CancelPendingActionsRequest;
import com.google.android.gms.drive.internal.DisconnectRequest;
import com.google.android.gms.drive.internal.RemoveEventListenerRequest;
import com.google.android.gms.drive.internal.zzae;
import com.google.android.gms.drive.internal.zzam;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzao;
import com.google.android.gms.drive.internal.zzbr;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.internal.zznt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class zzu
extends zzk<zzam> {
    private final String zzaaN;
    private final Bundle zzaxk;
    private final boolean zzaxl;
    private volatile DriveId zzaxm;
    private volatile DriveId zzaxn;
    private volatile boolean zzaxo = false;
    final GoogleApiClient.ConnectionCallbacks zzaxp;
    final Map<DriveId, Map<ChangeListener, zzae>> zzaxq = new HashMap<DriveId, Map<ChangeListener, zzae>>();
    final Map<zzc, zzae> zzaxr = new HashMap<zzc, zzae>();
    final Map<DriveId, Map<zzi, zzae>> zzaxs = new HashMap<DriveId, Map<zzi, zzae>>();
    final Map<DriveId, Map<zzi, zzae>> zzaxt = new HashMap<DriveId, Map<zzi, zzae>>();

    public zzu(Context context, Looper looper, zzg zzg2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, Bundle bundle) {
        super(context, looper, 11, zzg2, connectionCallbacks, onConnectionFailedListener);
        this.zzaaN = zzg2.zzty();
        this.zzaxp = connectionCallbacks;
        this.zzaxk = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.zzaxl = false;
                break;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    String string = String.valueOf(serviceInfo.name);
                    throw new IllegalStateException(new StringBuilder(60 + String.valueOf(string).length()).append("Drive event service ").append(string).append(" must be exported in AndroidManifest.xml").toString());
                }
                this.zzaxl = true;
                break;
            }
            default: {
                String string = String.valueOf(intent.getAction());
                throw new IllegalStateException(new StringBuilder(72 + String.valueOf(string).length()).append("AndroidManifest.xml can only define one service that handles the ").append(string).append(" action").toString());
            }
        }
    }

    public boolean zzpd() {
        return !this.getContext().getPackageName().equals(this.zzaaN) || !this.zzwm();
    }

    public boolean zztn() {
        return true;
    }

    boolean zzwm() {
        return GooglePlayServicesUtil.zze((Context)this.getContext(), (int)Process.myUid());
    }

    protected zzam zzbg(IBinder iBinder) {
        return zzam.zza.zzbh(iBinder);
    }

    protected String zzhU() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    protected Bundle zzoO() {
        String string = this.getContext().getPackageName();
        zzaa.zzz((Object)string);
        zzaa.zzai((!this.zztH().zztw().isEmpty() ? 1 : 0) != 0);
        Bundle bundle = new Bundle();
        if (!string.equals(this.zzaaN)) {
            bundle.putString("proxy_package_name", this.zzaaN);
        }
        bundle.putAll(this.zzaxk);
        return bundle;
    }

    protected String zzhT() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public zzam zzwn() throws DeadObjectException {
        return (zzam)this.zztm();
    }

    public DriveId zzwo() {
        return this.zzaxm;
    }

    public DriveId zzwp() {
        return this.zzaxn;
    }

    public boolean zzwq() {
        return this.zzaxo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Map<Object, Object> map;
        if (this.isConnected()) {
            try {
                map = (zzam)this.zztm();
                map.zza(new DisconnectRequest());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        super.disconnect();
        map = this.zzaxq;
        synchronized (map) {
            this.zzaxq.clear();
        }
        map = this.zzaxr;
        synchronized (map) {
            this.zzaxr.clear();
        }
        map = this.zzaxs;
        synchronized (map) {
            this.zzaxs.clear();
        }
        map = this.zzaxt;
        synchronized (map) {
            this.zzaxt.clear();
        }
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (bundle != null) {
            bundle.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.zzaxm = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.zzaxn = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
            this.zzaxo = true;
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public boolean zzwr() {
        return this.zzaxl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        boolean bl = true;
        zzaa.zzaj((boolean)com.google.android.gms.drive.events.zzg.zza(1, driveId));
        zzaa.zzb((Object)changeListener, (Object)"listener");
        zzaa.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        Map<DriveId, Map<ChangeListener, zzae>> map = this.zzaxq;
        synchronized (map) {
            zzae zzae2;
            Map<ChangeListener, zzae> map2 = this.zzaxq.get((Object)driveId);
            if (map2 == null) {
                map2 = new HashMap<ChangeListener, zzae>();
                this.zzaxq.put(driveId, map2);
            }
            if ((zzae2 = map2.get(changeListener)) == null) {
                zzae2 = new zzae(this.getLooper(), this.getContext(), 1, changeListener);
                map2.put(changeListener, zzae2);
            } else if (zzae2.zzdx(1)) {
                return new zzs.zzj(googleApiClient, Status.zzalw);
            }
            zzae2.zzdw(1);
            return this.zza(googleApiClient, new AddEventListenerRequest(1, driveId), zzae2);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final AddEventListenerRequest addEventListenerRequest, final zzae zzae2) {
        return googleApiClient.zzd((zznt.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzwn().zza(addEventListenerRequest, (zzao)zzae2, null, (zzan)new zzbr((zznt.zzb<Status>)this));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        boolean bl = true;
        zzaa.zzaj((boolean)com.google.android.gms.drive.events.zzg.zza(1, driveId));
        zzaa.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        zzaa.zzb((Object)changeListener, (Object)"listener");
        Map<DriveId, Map<ChangeListener, zzae>> map = this.zzaxq;
        synchronized (map) {
            Map<ChangeListener, zzae> map2 = this.zzaxq.get((Object)driveId);
            if (map2 == null) {
                return new zzs.zzj(googleApiClient, Status.zzalw);
            }
            zzae zzae2 = map2.remove(changeListener);
            if (zzae2 == null) {
                return new zzs.zzj(googleApiClient, Status.zzalw);
            }
            if (map2.isEmpty()) {
                this.zzaxq.remove((Object)driveId);
            }
            return this.zza(googleApiClient, new RemoveEventListenerRequest(driveId, 1), zzae2);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final RemoveEventListenerRequest removeEventListenerRequest, final zzae zzae2) {
        return googleApiClient.zzd((zznt.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzwn().zza(removeEventListenerRequest, (zzao)zzae2, null, (zzan)new zzbr((zznt.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, new AddEventListenerRequest(1, driveId));
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final AddEventListenerRequest addEventListenerRequest) {
        zzaa.zzaj((boolean)com.google.android.gms.drive.events.zzg.zza(addEventListenerRequest.getEventType(), addEventListenerRequest.getDriveId()));
        zzaa.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        if (!this.zzaxl) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient.zzd((zznt.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzwn().zza(addEventListenerRequest, null, null, (zzan)new zzbr((zznt.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, 1, driveId);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId) {
        zzaa.zzaj((boolean)com.google.android.gms.drive.events.zzg.zza(n, driveId));
        zzaa.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        return googleApiClient.zzd((zznt.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzwn().zza(new RemoveEventListenerRequest(driveId, n), null, null, (zzan)new zzbr((zznt.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> cancelPendingActions(GoogleApiClient googleApiClient, final List<String> list) {
        zzaa.zzaj((list != null ? 1 : 0) != 0);
        zzaa.zzaj((!list.isEmpty() ? 1 : 0) != 0);
        zzaa.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        return googleApiClient.zzd((zznt.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzwn().zza(new CancelPendingActionsRequest(list), (zzan)new zzbr((zznt.zzb<Status>)this));
            }
        });
    }

    protected /* synthetic */ IInterface zzab(IBinder iBinder) {
        return this.zzbg(iBinder);
    }
}

