/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CloseContentsAndUpdateMetadataRequest;
import com.google.android.gms.drive.internal.CloseContentsRequest;
import com.google.android.gms.drive.internal.OpenContentsRequest;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzbi;
import com.google.android.gms.drive.internal.zzbr;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.drive.zzi;
import com.google.android.gms.internal.zznt;
import java.io.InputStream;
import java.io.OutputStream;

public class zzv
implements DriveContents {
    private final Contents zzaxB;
    private boolean mClosed = false;
    private boolean zzaxC = false;
    private boolean zzaxD = false;

    public zzv(Contents contents) {
        this.zzaxB = (Contents)((Object)zzaa.zzz((Object)((Object)contents)));
    }

    @Override
    public DriveId getDriveId() {
        return this.zzaxB.getDriveId();
    }

    @Override
    public int getMode() {
        return this.zzaxB.getMode();
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() {
        if (this.zzvI()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        return this.zzaxB.getParcelFileDescriptor();
    }

    @Override
    public InputStream getInputStream() {
        if (this.zzvI()) {
            throw new IllegalStateException("Contents have been closed, cannot access the input stream.");
        }
        if (this.zzaxB.getMode() != 0x10000000) {
            throw new IllegalStateException("getInputStream() can only be used with contents opened with MODE_READ_ONLY.");
        }
        if (this.zzaxC) {
            throw new IllegalStateException("getInputStream() can only be called once per Contents instance.");
        }
        this.zzaxC = true;
        return this.zzaxB.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.zzvI()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        if (this.zzaxB.getMode() != 0x20000000) {
            throw new IllegalStateException("getOutputStream() can only be used with contents opened with MODE_WRITE_ONLY.");
        }
        if (this.zzaxD) {
            throw new IllegalStateException("getOutputStream() can only be called once per Contents instance.");
        }
        this.zzaxD = true;
        return this.zzaxB.getOutputStream();
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> reopenForWrite(GoogleApiClient googleApiClient) {
        if (this.zzvI()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.zzaxB.getMode() != 0x10000000) {
            throw new IllegalStateException("reopenForWrite can only be used with DriveContents opened with MODE_READ_ONLY.");
        }
        this.zzvH();
        return googleApiClient.zzc((zznt.zza)new zzs.zzc(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzwn().zza(new OpenContentsRequest(zzv.this.getDriveId(), 0x20000000, zzv.this.zzaxB.getRequestId()), (zzan)new zzbi((zznt.zzb<DriveApi.DriveContentsResult>)this, null));
            }
        });
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet) {
        return this.zza(googleApiClient, metadataChangeSet, null);
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, ExecutionOptions executionOptions) {
        return this.zza(googleApiClient, metadataChangeSet, executionOptions == null ? null : zzi.zzb(executionOptions));
    }

    public PendingResult<Status> zza(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, zzi zzi2) {
        if (zzi2 == null) {
            zzi2 = (zzi)new zzi.zza().build();
        }
        if (this.zzaxB.getMode() == 0x10000000) {
            throw new IllegalStateException("Cannot commit contents opened with MODE_READ_ONLY");
        }
        if (ExecutionOptions.zzcL(zzi2.zzvM()) && !this.zzaxB.zzvE()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        zzi2.zzg(googleApiClient);
        if (this.zzvI()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.getDriveId() == null) {
            throw new IllegalStateException("Only DriveContents obtained through DriveFile.open can be committed.");
        }
        final MetadataChangeSet metadataChangeSet2 = metadataChangeSet != null ? metadataChangeSet : MetadataChangeSet.zzavD;
        final zzi zzi3 = zzi2;
        this.zzvH();
        return googleApiClient.zzd((zznt.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                metadataChangeSet2.zzvU().setContext(zzu2.getContext());
                zzu2.zzwn().zza(new CloseContentsAndUpdateMetadataRequest(zzv.this.zzaxB.getDriveId(), metadataChangeSet2.zzvU(), zzv.this.zzaxB.getRequestId(), zzv.this.zzaxB.zzvE(), zzi3), (zzan)new zzbr((zznt.zzb<Status>)this));
            }
        });
    }

    @Override
    public void discard(GoogleApiClient googleApiClient) {
        if (this.zzvI()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        this.zzvH();
        (googleApiClient.zzd((zznt.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzwn().zza(new CloseContentsRequest(zzv.this.zzaxB.getRequestId(), false), (zzan)new zzbr((zznt.zzb<Status>)this));
            }
        })).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void zzo(Status status) {
                if (!status.isSuccess()) {
                    zzz.zzE("DriveContentsImpl", "Error discarding contents");
                } else {
                    zzz.zzC("DriveContentsImpl", "Contents discarded");
                }
            }

            public /* synthetic */ void onResult(Result result) {
                this.zzo((Status)result);
            }
        });
    }

    @Override
    public Contents zzvG() {
        return this.zzaxB;
    }

    @Override
    public void zzvH() {
        zzo.zza((ParcelFileDescriptor)this.zzaxB.getParcelFileDescriptor());
        this.mClosed = true;
    }

    @Override
    public boolean zzvI() {
        return this.mClosed;
    }
}

