/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.query;

import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.SearchableCollectionMetadataField;
import com.google.android.gms.drive.metadata.SearchableMetadataField;
import com.google.android.gms.drive.metadata.SearchableOrderedMetadataField;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.query.Filter;
import com.google.android.gms.drive.query.SearchableField;
import com.google.android.gms.drive.query.internal.ComparisonFilter;
import com.google.android.gms.drive.query.internal.FieldOnlyFilter;
import com.google.android.gms.drive.query.internal.HasFilter;
import com.google.android.gms.drive.query.internal.InFilter;
import com.google.android.gms.drive.query.internal.LogicalFilter;
import com.google.android.gms.drive.query.internal.NotFilter;
import com.google.android.gms.drive.query.internal.Operator;
import com.google.android.gms.drive.query.internal.OwnedByMeFilter;

public class Filters {
    public static <T> Filter eq(SearchableMetadataField<T> searchableMetadataField, T t) {
        return new ComparisonFilter<T>(Operator.zzaAY, searchableMetadataField, t);
    }

    public static <T extends Comparable<T>> Filter lessThan(SearchableOrderedMetadataField<T> searchableOrderedMetadataField, T t) {
        return new ComparisonFilter<T>(Operator.zzaAZ, searchableOrderedMetadataField, t);
    }

    public static <T extends Comparable<T>> Filter greaterThan(SearchableOrderedMetadataField<T> searchableOrderedMetadataField, T t) {
        return new ComparisonFilter<T>(Operator.zzaBb, searchableOrderedMetadataField, t);
    }

    public static <T extends Comparable<T>> Filter lessThanEquals(SearchableOrderedMetadataField<T> searchableOrderedMetadataField, T t) {
        return new ComparisonFilter<T>(Operator.zzaBa, searchableOrderedMetadataField, t);
    }

    public static <T extends Comparable<T>> Filter greaterThanEquals(SearchableOrderedMetadataField<T> searchableOrderedMetadataField, T t) {
        return new ComparisonFilter<T>(Operator.zzaBc, searchableOrderedMetadataField, t);
    }

    public static <T> Filter in(SearchableCollectionMetadataField<T> searchableCollectionMetadataField, T t) {
        return new InFilter<T>(searchableCollectionMetadataField, t);
    }

    public static Filter eq(CustomPropertyKey customPropertyKey, String string) {
        zzaa.zzb((string != null ? 1 : 0) != 0, (Object)"Custom property value may not be null.");
        return new HasFilter<AppVisibleCustomProperties>(SearchableField.zzaAD, new AppVisibleCustomProperties.zza().zza(customPropertyKey, string).zzwJ());
    }

    public static Filter contains(SearchableMetadataField<String> searchableMetadataField, String string) {
        return new ComparisonFilter<String>(Operator.zzaBg, searchableMetadataField, string);
    }

    public static Filter and(Filter filter, Filter ... filterArray) {
        return new LogicalFilter(Operator.zzaBd, filter, filterArray);
    }

    public static Filter and(Iterable<Filter> iterable) {
        return new LogicalFilter(Operator.zzaBd, iterable);
    }

    public static Filter or(Filter filter, Filter ... filterArray) {
        return new LogicalFilter(Operator.zzaBe, filter, filterArray);
    }

    public static Filter or(Iterable<Filter> iterable) {
        return new LogicalFilter(Operator.zzaBe, iterable);
    }

    public static Filter not(Filter filter) {
        return new NotFilter(filter);
    }

    public static Filter sharedWithMe() {
        return new FieldOnlyFilter(SearchableField.zzaAC);
    }

    public static Filter openedByMe() {
        return new FieldOnlyFilter(SearchableField.LAST_VIEWED_BY_ME);
    }

    public static Filter ownedByMe() {
        return new OwnedByMeFilter();
    }
}

