/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fido.u2f.api.common.zzb;
import com.google.android.gms.fido.u2f.api.common.zzc;
import com.google.android.gms.internal.zzbcc;
import com.google.android.gms.internal.zzbcf;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelIdValue
extends zzbcc {
    public static final Parcelable.Creator<ChannelIdValue> CREATOR = new zzc();
    public static final ChannelIdValue ABSENT = new ChannelIdValue();
    public static final ChannelIdValue UNAVAILABLE = new ChannelIdValue("unavailable");
    public static final ChannelIdValue UNUSED = new ChannelIdValue("unused");
    private final ChannelIdValueType zzgqb;
    private final String zzgqc;
    private final String zzgqd;

    ChannelIdValue(int n, String string, String string2) {
        try {
            this.zzgqb = ChannelIdValue.toChannelIdValueType(n);
        }
        catch (UnsupportedChannelIdValueTypeException unsupportedChannelIdValueTypeException) {
            throw new IllegalArgumentException(unsupportedChannelIdValueTypeException);
        }
        this.zzgqc = string;
        this.zzgqd = string2;
    }

    public ChannelIdValue(JSONObject jSONObject) {
        this.zzgqd = (String)zzbp.zzu((Object)jSONObject.toString());
        this.zzgqb = ChannelIdValueType.OBJECT;
        this.zzgqc = null;
    }

    private ChannelIdValue() {
        this.zzgqb = ChannelIdValueType.ABSENT;
        this.zzgqd = null;
        this.zzgqc = null;
    }

    private ChannelIdValue(String string) {
        this.zzgqc = (String)zzbp.zzu((Object)string);
        this.zzgqb = ChannelIdValueType.STRING;
        this.zzgqd = null;
    }

    public static ChannelIdValueType toChannelIdValueType(int n) throws UnsupportedChannelIdValueTypeException {
        for (ChannelIdValueType channelIdValueType : ChannelIdValueType.values()) {
            if (n != channelIdValueType.zzeda) continue;
            return channelIdValueType;
        }
        throw new UnsupportedChannelIdValueTypeException(n);
    }

    public int getTypeAsInt() {
        return this.zzgqb.zzeda;
    }

    public ChannelIdValueType getType() {
        return this.zzgqb;
    }

    public String getObjectValueAsString() {
        return this.zzgqd;
    }

    public JSONObject getObjectValue() {
        if (this.zzgqd == null) {
            return null;
        }
        try {
            return new JSONObject(this.zzgqd);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public String getStringValue() {
        return this.zzgqc;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ChannelIdValue channelIdValue = this;
        int n2 = zzbcf.zze((Parcel)parcel2);
        zzbcf.zzc((Parcel)parcel2, (int)2, (int)channelIdValue.getTypeAsInt());
        zzbcf.zza((Parcel)parcel2, (int)3, (String)channelIdValue.getStringValue(), (boolean)false);
        zzbcf.zza((Parcel)parcel2, (int)4, (String)channelIdValue.getObjectValueAsString(), (boolean)false);
        zzbcf.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChannelIdValue)) {
            return false;
        }
        ChannelIdValue channelIdValue = (ChannelIdValue)((Object)object);
        if (!this.zzgqb.equals((Object)channelIdValue.zzgqb)) {
            return false;
        }
        switch (this.zzgqb) {
            case ABSENT: {
                return true;
            }
            case STRING: {
                return this.zzgqc.equals(channelIdValue.zzgqc);
            }
            case OBJECT: {
                return this.zzgqd.equals(channelIdValue.zzgqd);
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 31 + this.zzgqb.hashCode();
        switch (this.zzgqb) {
            case ABSENT: {
                break;
            }
            case STRING: {
                n = n * 31 + this.zzgqc.hashCode();
                break;
            }
            case OBJECT: {
                n = n * 31 + this.zzgqd.hashCode();
            }
        }
        return n;
    }

    public static class UnsupportedChannelIdValueTypeException
    extends Exception {
        public UnsupportedChannelIdValueTypeException(int n) {
            super(String.format("ChannelIdValueType %s not supported", n));
        }
    }

    public static enum ChannelIdValueType implements Parcelable
    {
        ABSENT(0),
        STRING(1),
        OBJECT(2);

        public static final Parcelable.Creator<ChannelIdValueType> CREATOR;
        private final int zzeda;

        private ChannelIdValueType(int n2) {
            this.zzeda = n2;
        }

        public final int describeContents() {
            return 0;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.zzeda);
        }

        static {
            CREATOR = new zzb();
        }
    }
}

