/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import com.google.android.gms.fido.u2f.api.common.RegisterRequest;
import com.google.android.gms.fido.u2f.api.common.RegisteredKey;
import com.google.android.gms.fido.u2f.api.common.RequestParams;
import com.google.android.gms.fido.u2f.api.common.zzj;
import com.google.android.gms.internal.zzbcf;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RegisterRequestParams
extends RequestParams {
    public static final Parcelable.Creator<RegisterRequestParams> CREATOR = new zzj();
    public static final int MAX_DISPLAY_HINT_LENGTH = 80;
    private final Integer zzgge;
    private final Double zzgqp;
    private final Uri zzgqq;
    private final List<RegisterRequest> zzgqr;
    private final List<RegisteredKey> zzgqs;
    private final ChannelIdValue zzgqt;
    private final String zzgqu;
    private Set<Uri> zzgqv;

    RegisterRequestParams(Integer n, Double d, Uri uri, List<RegisterRequest> list, List<RegisteredKey> list2, ChannelIdValue channelIdValue, String string) {
        this.zzgge = n;
        this.zzgqp = d;
        this.zzgqq = uri;
        zzbp.zzb((list != null && !list.isEmpty() ? 1 : 0) != 0, (Object)"empty list of register requests is provided");
        this.zzgqr = list;
        this.zzgqs = list2;
        this.zzgqt = channelIdValue;
        List<RegisteredKey> list3 = this.zzgqs;
        List<RegisterRequest> list4 = this.zzgqr;
        Uri uri2 = this.zzgqq;
        HashSet<Uri> hashSet = new HashSet<Uri>();
        if (uri2 != null) {
            hashSet.add(uri2);
        }
        for (RegisterRequest zzbcc2 : list4) {
            zzbp.zzb((uri2 != null || zzbcc2.getAppId() != null ? 1 : 0) != 0, (Object)"register request has null appId and no request appId is provided");
            if (zzbcc2.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)zzbcc2.getAppId()));
        }
        for (RegisteredKey registeredKey : list3) {
            zzbp.zzb((uri2 != null || registeredKey.getAppId() != null ? 1 : 0) != 0, (Object)"registered key has null appId and no request appId is provided");
            if (registeredKey.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)registeredKey.getAppId()));
        }
        this.zzgqv = hashSet;
        zzbp.zzb((string == null || string.length() <= 80 ? 1 : 0) != 0, (Object)"Display Hint cannot be longer than 80 characters");
        this.zzgqu = string;
    }

    @Override
    public Integer getRequestId() {
        return this.zzgge;
    }

    @Override
    public Double getTimeoutSeconds() {
        return this.zzgqp;
    }

    @Override
    public Uri getAppId() {
        return this.zzgqq;
    }

    @Override
    public Set<Uri> getAllAppIds() {
        return this.zzgqv;
    }

    public List<RegisterRequest> getRegisterRequests() {
        return this.zzgqr;
    }

    @Override
    public List<RegisteredKey> getRegisteredKeys() {
        return this.zzgqs;
    }

    @Override
    public ChannelIdValue getChannelIdValue() {
        return this.zzgqt;
    }

    @Override
    public String getDisplayHint() {
        return this.zzgqu;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        RegisterRequestParams registerRequestParams = (RegisterRequestParams)((Object)object);
        return zzbf.equal((Object)this.zzgge, (Object)registerRequestParams.zzgge) && zzbf.equal((Object)this.zzgqp, (Object)registerRequestParams.zzgqp) && zzbf.equal((Object)this.zzgqq, (Object)registerRequestParams.zzgqq) && zzbf.equal(this.zzgqr, registerRequestParams.zzgqr) && (this.zzgqs == null && registerRequestParams.zzgqs == null || this.zzgqs != null && registerRequestParams.zzgqs != null && this.zzgqs.containsAll(registerRequestParams.zzgqs) && registerRequestParams.zzgqs.containsAll(this.zzgqs)) && zzbf.equal((Object)((Object)this.zzgqt), (Object)((Object)registerRequestParams.zzgqt)) && zzbf.equal((Object)this.zzgqu, (Object)registerRequestParams.zzgqu);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgge, this.zzgqq, this.zzgqp, this.zzgqr, this.zzgqs, this.zzgqt, this.zzgqu});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RegisterRequestParams registerRequestParams = this;
        int n2 = zzbcf.zze((Parcel)parcel2);
        zzbcf.zza((Parcel)parcel2, (int)2, (Integer)((RequestParams)registerRequestParams).getRequestId(), (boolean)false);
        zzbcf.zza((Parcel)parcel2, (int)3, (Double)((RequestParams)registerRequestParams).getTimeoutSeconds(), (boolean)false);
        zzbcf.zza((Parcel)parcel2, (int)4, (Parcelable)((RequestParams)registerRequestParams).getAppId(), (int)n, (boolean)false);
        zzbcf.zzc((Parcel)parcel2, (int)5, registerRequestParams.getRegisterRequests(), (boolean)false);
        zzbcf.zzc((Parcel)parcel2, (int)6, ((RequestParams)registerRequestParams).getRegisteredKeys(), (boolean)false);
        zzbcf.zza((Parcel)parcel2, (int)7, (Parcelable)((RequestParams)registerRequestParams).getChannelIdValue(), (int)n, (boolean)false);
        zzbcf.zza((Parcel)parcel2, (int)8, (String)((RequestParams)registerRequestParams).getDisplayHint(), (boolean)false);
        zzbcf.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private Integer zzgge;
        private Double zzgqp;
        private Uri zzgqq;
        private List<RegisterRequest> zzgqr;
        private List<RegisteredKey> zzgqs;
        private ChannelIdValue zzgqt;
        private String zzgqu;

        public Builder() {
        }

        public final Builder setRequestId(Integer n) {
            this.zzgge = n;
            return this;
        }

        public final Builder setTimeoutSeconds(Double d) {
            this.zzgqp = d;
            return this;
        }

        public final Builder setAppId(Uri uri) {
            this.zzgqq = uri;
            return this;
        }

        public final Builder setRegisterRequests(List<RegisterRequest> list) {
            this.zzgqr = list;
            return this;
        }

        public final Builder setRegisteredKeys(List<RegisteredKey> list) {
            this.zzgqs = list;
            return this;
        }

        public final Builder setChannelIdValue(ChannelIdValue channelIdValue) {
            this.zzgqt = channelIdValue;
            return this;
        }

        public final Builder setDisplayHint(String string) {
            this.zzgqu = string;
            return this;
        }

        public final RegisterRequestParams build() {
            return new RegisterRequestParams(this.zzgge, this.zzgqp, this.zzgqq, this.zzgqr, this.zzgqs, this.zzgqt, this.zzgqu);
        }
    }
}

