/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fido.u2f.api.common.zzb;
import com.google.android.gms.fido.u2f.api.common.zzc;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelIdValue
extends zzbck {
    public static final Parcelable.Creator<ChannelIdValue> CREATOR = new zzc();
    public static final ChannelIdValue ABSENT = new ChannelIdValue();
    public static final ChannelIdValue UNAVAILABLE = new ChannelIdValue("unavailable");
    public static final ChannelIdValue UNUSED = new ChannelIdValue("unused");
    private final ChannelIdValueType zzgqj;
    private final String zzgqk;
    private final String zzgql;

    ChannelIdValue(int n, String string, String string2) {
        try {
            this.zzgqj = ChannelIdValue.toChannelIdValueType(n);
        }
        catch (UnsupportedChannelIdValueTypeException unsupportedChannelIdValueTypeException) {
            throw new IllegalArgumentException(unsupportedChannelIdValueTypeException);
        }
        this.zzgqk = string;
        this.zzgql = string2;
    }

    public ChannelIdValue(JSONObject jSONObject) {
        this.zzgql = (String)zzbp.zzu((Object)jSONObject.toString());
        this.zzgqj = ChannelIdValueType.OBJECT;
        this.zzgqk = null;
    }

    private ChannelIdValue() {
        this.zzgqj = ChannelIdValueType.ABSENT;
        this.zzgql = null;
        this.zzgqk = null;
    }

    private ChannelIdValue(String string) {
        this.zzgqk = (String)zzbp.zzu((Object)string);
        this.zzgqj = ChannelIdValueType.STRING;
        this.zzgql = null;
    }

    public static ChannelIdValueType toChannelIdValueType(int n) throws UnsupportedChannelIdValueTypeException {
        for (ChannelIdValueType channelIdValueType : ChannelIdValueType.values()) {
            if (n != channelIdValueType.zzecy) continue;
            return channelIdValueType;
        }
        throw new UnsupportedChannelIdValueTypeException(n);
    }

    public int getTypeAsInt() {
        return this.zzgqj.zzecy;
    }

    public ChannelIdValueType getType() {
        return this.zzgqj;
    }

    public String getObjectValueAsString() {
        return this.zzgql;
    }

    public JSONObject getObjectValue() {
        if (this.zzgql == null) {
            return null;
        }
        try {
            return new JSONObject(this.zzgql);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public String getStringValue() {
        return this.zzgqk;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ChannelIdValue channelIdValue = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)2, (int)channelIdValue.getTypeAsInt());
        zzbcn.zza((Parcel)parcel2, (int)3, (String)channelIdValue.getStringValue(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (String)channelIdValue.getObjectValueAsString(), (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChannelIdValue)) {
            return false;
        }
        ChannelIdValue channelIdValue = (ChannelIdValue)((Object)object);
        if (!this.zzgqj.equals((Object)channelIdValue.zzgqj)) {
            return false;
        }
        switch (this.zzgqj) {
            case ABSENT: {
                return true;
            }
            case STRING: {
                return this.zzgqk.equals(channelIdValue.zzgqk);
            }
            case OBJECT: {
                return this.zzgql.equals(channelIdValue.zzgql);
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 31 + this.zzgqj.hashCode();
        switch (this.zzgqj) {
            case ABSENT: {
                break;
            }
            case STRING: {
                n = n * 31 + this.zzgqk.hashCode();
                break;
            }
            case OBJECT: {
                n = n * 31 + this.zzgql.hashCode();
            }
        }
        return n;
    }

    public static class UnsupportedChannelIdValueTypeException
    extends Exception {
        public UnsupportedChannelIdValueTypeException(int n) {
            super(String.format("ChannelIdValueType %s not supported", n));
        }
    }

    public static enum ChannelIdValueType implements Parcelable
    {
        ABSENT(0),
        STRING(1),
        OBJECT(2);

        public static final Parcelable.Creator<ChannelIdValueType> CREATOR;
        private final int zzecy;

        private ChannelIdValueType(int n2) {
            this.zzecy = n2;
        }

        public final int describeContents() {
            return 0;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.zzecy);
        }

        static {
            CREATOR = new zzb();
        }
    }
}

