/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fido.u2f.api.common.ProtocolVersion;
import com.google.android.gms.fido.u2f.api.common.zzi;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class RegisterRequest
extends zzbck {
    public static final Parcelable.Creator<RegisterRequest> CREATOR = new zzi();
    public static final int U2F_V1_CHALLENGE_BYTE_LENGTH = 65;
    private final int zzdxs;
    private final ProtocolVersion zzgqv;
    private final byte[] zzgqx;
    private final String mAppId;

    RegisterRequest(int n, String string, byte[] byArray, String string2) {
        this.zzdxs = n;
        try {
            this.zzgqv = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new IllegalArgumentException(unsupportedProtocolException);
        }
        this.zzgqx = byArray;
        this.mAppId = string2;
    }

    public RegisterRequest(ProtocolVersion protocolVersion, byte[] byArray, String string) {
        this.zzdxs = 1;
        this.zzgqv = (ProtocolVersion)((Object)zzbp.zzu((Object)((Object)protocolVersion)));
        this.zzgqx = (byte[])zzbp.zzu((Object)byArray);
        if (protocolVersion == ProtocolVersion.V1) {
            zzbp.zzb((byArray.length == 65 ? 1 : 0) != 0, (Object)"invalid challengeValue length for V1");
        }
        this.mAppId = string;
    }

    public static RegisterRequest parseFromJson(JSONObject jSONObject) throws JSONException {
        byte[] byArray;
        ProtocolVersion protocolVersion;
        String string = null;
        if (jSONObject.has("version")) {
            string = jSONObject.getString("version");
        }
        try {
            protocolVersion = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new JSONException(unsupportedProtocolException.toString());
        }
        String string2 = jSONObject.getString("challenge");
        try {
            byArray = Base64.decode((String)string2, (int)8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JSONException(illegalArgumentException.toString());
        }
        String string3 = null;
        if (jSONObject.has("appId")) {
            string3 = jSONObject.getString("appId");
        }
        try {
            return new RegisterRequest(protocolVersion, byArray, string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JSONException(illegalArgumentException.getMessage());
        }
    }

    public int getVersionCode() {
        return this.zzdxs;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.zzgqv;
    }

    public byte[] getChallengeValue() {
        return this.zzgqx;
    }

    public String getAppId() {
        return this.mAppId;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RegisterRequest registerRequest = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)1, (int)registerRequest.getVersionCode());
        zzbcn.zza((Parcel)parcel2, (int)2, (String)registerRequest.zzgqv.toString(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (byte[])registerRequest.getChallengeValue(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (String)registerRequest.getAppId(), (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        int n = 31 + Arrays.hashCode(this.zzgqx);
        n = n * 31 + this.zzgqv.hashCode();
        return n * 31 + (this.mAppId == null ? 0 : this.mAppId.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        RegisterRequest registerRequest = (RegisterRequest)((Object)object);
        if (!Arrays.equals(this.zzgqx, registerRequest.zzgqx)) {
            return false;
        }
        if (this.zzgqv != registerRequest.zzgqv) {
            return false;
        }
        return !(this.mAppId == null ? registerRequest.mAppId != null : !this.mAppId.equals(registerRequest.mAppId));
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("version", (Object)this.zzgqv.toString());
            jSONObject.put("challenge", (Object)Base64.encodeToString((byte[])this.zzgqx, (int)11));
            if (this.mAppId != null) {
                jSONObject.put("appId", (Object)this.mAppId);
            }
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        return jSONObject;
    }
}

