/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.zzb;
import com.google.android.gms.fido.u2f.api.common.zzc;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelIdValue
extends zzbej {
    public static final Parcelable.Creator<ChannelIdValue> CREATOR = new zzc();
    public static final ChannelIdValue ABSENT = new ChannelIdValue();
    public static final ChannelIdValue UNAVAILABLE = new ChannelIdValue("unavailable");
    public static final ChannelIdValue UNUSED = new ChannelIdValue("unused");
    private final ChannelIdValueType zzguy;
    private final String zzguz;
    private final String zzgva;

    ChannelIdValue(int n, String string, String string2) {
        try {
            this.zzguy = ChannelIdValue.toChannelIdValueType(n);
        }
        catch (UnsupportedChannelIdValueTypeException unsupportedChannelIdValueTypeException) {
            throw new IllegalArgumentException(unsupportedChannelIdValueTypeException);
        }
        this.zzguz = string;
        this.zzgva = string2;
    }

    public ChannelIdValue(JSONObject jSONObject) {
        this.zzgva = (String)zzbq.checkNotNull((Object)jSONObject.toString());
        this.zzguy = ChannelIdValueType.OBJECT;
        this.zzguz = null;
    }

    private ChannelIdValue() {
        this.zzguy = ChannelIdValueType.ABSENT;
        this.zzgva = null;
        this.zzguz = null;
    }

    private ChannelIdValue(String string) {
        this.zzguz = (String)zzbq.checkNotNull((Object)string);
        this.zzguy = ChannelIdValueType.STRING;
        this.zzgva = null;
    }

    public static ChannelIdValueType toChannelIdValueType(int n) throws UnsupportedChannelIdValueTypeException {
        for (ChannelIdValueType channelIdValueType : ChannelIdValueType.values()) {
            if (n != channelIdValueType.zzefe) continue;
            return channelIdValueType;
        }
        throw new UnsupportedChannelIdValueTypeException(n);
    }

    public int getTypeAsInt() {
        return this.zzguy.zzefe;
    }

    public ChannelIdValueType getType() {
        return this.zzguy;
    }

    public String getObjectValueAsString() {
        return this.zzgva;
    }

    public JSONObject getObjectValue() {
        if (this.zzgva == null) {
            return null;
        }
        try {
            return new JSONObject(this.zzgva);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public String getStringValue() {
        return this.zzguz;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ChannelIdValue channelIdValue = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zzc((Parcel)parcel2, (int)2, (int)channelIdValue.getTypeAsInt());
        zzbem.zza((Parcel)parcel2, (int)3, (String)channelIdValue.getStringValue(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (String)channelIdValue.getObjectValueAsString(), (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChannelIdValue)) {
            return false;
        }
        ChannelIdValue channelIdValue = (ChannelIdValue)((Object)object);
        if (!this.zzguy.equals((Object)channelIdValue.zzguy)) {
            return false;
        }
        switch (this.zzguy) {
            case ABSENT: {
                return true;
            }
            case STRING: {
                return this.zzguz.equals(channelIdValue.zzguz);
            }
            case OBJECT: {
                return this.zzgva.equals(channelIdValue.zzgva);
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 31 + this.zzguy.hashCode();
        switch (this.zzguy) {
            case ABSENT: {
                break;
            }
            case STRING: {
                n = n * 31 + this.zzguz.hashCode();
                break;
            }
            case OBJECT: {
                n = n * 31 + this.zzgva.hashCode();
            }
        }
        return n;
    }

    public static class UnsupportedChannelIdValueTypeException
    extends Exception {
        public UnsupportedChannelIdValueTypeException(int n) {
            super(String.format("ChannelIdValueType %s not supported", n));
        }
    }

    public static enum ChannelIdValueType implements Parcelable
    {
        ABSENT(0),
        STRING(1),
        OBJECT(2);

        public static final Parcelable.Creator<ChannelIdValueType> CREATOR;
        private final int zzefe;

        private ChannelIdValueType(int n2) {
            this.zzefe = n2;
        }

        public final int describeContents() {
            return 0;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.zzefe);
        }

        static {
            CREATOR = new zzb();
        }
    }
}

