/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import com.google.android.gms.fido.u2f.api.common.RegisterRequest;
import com.google.android.gms.fido.u2f.api.common.RegisteredKey;
import com.google.android.gms.fido.u2f.api.common.RequestParams;
import com.google.android.gms.fido.u2f.api.common.zzj;
import com.google.android.gms.internal.zzbem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RegisterRequestParams
extends RequestParams {
    public static final Parcelable.Creator<RegisterRequestParams> CREATOR = new zzj();
    public static final int MAX_DISPLAY_HINT_LENGTH = 80;
    private final Integer zzgjx;
    private final Double zzgvm;
    private final Uri zzgvn;
    private final List<RegisterRequest> zzgvo;
    private final List<RegisteredKey> zzgvp;
    private final ChannelIdValue zzgvq;
    private final String zzgvr;
    private Set<Uri> zzgvs;

    RegisterRequestParams(Integer n, Double d, Uri uri, List<RegisterRequest> list, List<RegisteredKey> list2, ChannelIdValue channelIdValue, String string) {
        this.zzgjx = n;
        this.zzgvm = d;
        this.zzgvn = uri;
        zzbq.checkArgument((list != null && !list.isEmpty() ? 1 : 0) != 0, (Object)"empty list of register requests is provided");
        this.zzgvo = list;
        this.zzgvp = list2;
        this.zzgvq = channelIdValue;
        List<RegisteredKey> list3 = this.zzgvp;
        List<RegisterRequest> list4 = this.zzgvo;
        Uri uri2 = this.zzgvn;
        HashSet<Uri> hashSet = new HashSet<Uri>();
        if (uri2 != null) {
            hashSet.add(uri2);
        }
        for (RegisterRequest zzbej2 : list4) {
            zzbq.checkArgument((uri2 != null || zzbej2.getAppId() != null ? 1 : 0) != 0, (Object)"register request has null appId and no request appId is provided");
            if (zzbej2.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)zzbej2.getAppId()));
        }
        for (RegisteredKey registeredKey : list3) {
            zzbq.checkArgument((uri2 != null || registeredKey.getAppId() != null ? 1 : 0) != 0, (Object)"registered key has null appId and no request appId is provided");
            if (registeredKey.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)registeredKey.getAppId()));
        }
        this.zzgvs = hashSet;
        zzbq.checkArgument((string == null || string.length() <= 80 ? 1 : 0) != 0, (Object)"Display Hint cannot be longer than 80 characters");
        this.zzgvr = string;
    }

    @Override
    public Integer getRequestId() {
        return this.zzgjx;
    }

    @Override
    public Double getTimeoutSeconds() {
        return this.zzgvm;
    }

    @Override
    public Uri getAppId() {
        return this.zzgvn;
    }

    @Override
    public Set<Uri> getAllAppIds() {
        return this.zzgvs;
    }

    public List<RegisterRequest> getRegisterRequests() {
        return this.zzgvo;
    }

    @Override
    public List<RegisteredKey> getRegisteredKeys() {
        return this.zzgvp;
    }

    @Override
    public ChannelIdValue getChannelIdValue() {
        return this.zzgvq;
    }

    @Override
    public String getDisplayHint() {
        return this.zzgvr;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        RegisterRequestParams registerRequestParams = (RegisterRequestParams)((Object)object);
        return zzbg.equal((Object)this.zzgjx, (Object)registerRequestParams.zzgjx) && zzbg.equal((Object)this.zzgvm, (Object)registerRequestParams.zzgvm) && zzbg.equal((Object)this.zzgvn, (Object)registerRequestParams.zzgvn) && zzbg.equal(this.zzgvo, registerRequestParams.zzgvo) && (this.zzgvp == null && registerRequestParams.zzgvp == null || this.zzgvp != null && registerRequestParams.zzgvp != null && this.zzgvp.containsAll(registerRequestParams.zzgvp) && registerRequestParams.zzgvp.containsAll(this.zzgvp)) && zzbg.equal((Object)((Object)this.zzgvq), (Object)((Object)registerRequestParams.zzgvq)) && zzbg.equal((Object)this.zzgvr, (Object)registerRequestParams.zzgvr);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgjx, this.zzgvn, this.zzgvm, this.zzgvo, this.zzgvp, this.zzgvq, this.zzgvr});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RegisterRequestParams registerRequestParams = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)2, (Integer)((RequestParams)registerRequestParams).getRequestId(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (Double)((RequestParams)registerRequestParams).getTimeoutSeconds(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (Parcelable)((RequestParams)registerRequestParams).getAppId(), (int)n, (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)5, registerRequestParams.getRegisterRequests(), (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)6, ((RequestParams)registerRequestParams).getRegisteredKeys(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)7, (Parcelable)((RequestParams)registerRequestParams).getChannelIdValue(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)8, (String)((RequestParams)registerRequestParams).getDisplayHint(), (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private Integer zzgjx;
        private Double zzgvm;
        private Uri zzgvn;
        private List<RegisterRequest> zzgvo;
        private List<RegisteredKey> zzgvp;
        private ChannelIdValue zzgvq;
        private String zzgvr;

        public Builder() {
        }

        public final Builder setRequestId(Integer n) {
            this.zzgjx = n;
            return this;
        }

        public final Builder setTimeoutSeconds(Double d) {
            this.zzgvm = d;
            return this;
        }

        public final Builder setAppId(Uri uri) {
            this.zzgvn = uri;
            return this;
        }

        public final Builder setRegisterRequests(List<RegisterRequest> list) {
            this.zzgvo = list;
            return this;
        }

        public final Builder setRegisteredKeys(List<RegisteredKey> list) {
            this.zzgvp = list;
            return this;
        }

        public final Builder setChannelIdValue(ChannelIdValue channelIdValue) {
            this.zzgvq = channelIdValue;
            return this;
        }

        public final Builder setDisplayHint(String string) {
            this.zzgvr = string;
            return this;
        }

        public final RegisterRequestParams build() {
            return new RegisterRequestParams(this.zzgjx, this.zzgvm, this.zzgvn, this.zzgvo, this.zzgvp, this.zzgvq, this.zzgvr);
        }
    }
}

