/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorResponse;
import com.google.android.gms.fido.fido2.api.common.ErrorCode;
import com.google.android.gms.fido.fido2.api.common.zzf;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbgp;
import com.google.android.gms.internal.zzbgq;
import java.util.Arrays;

public class AuthenticatorErrorResponse
extends AuthenticatorResponse {
    @Hide
    public static final Parcelable.Creator<AuthenticatorErrorResponse> CREATOR = new zzf();
    private final ErrorCode zza;
    private final String zzb;

    public static AuthenticatorErrorResponse deserializeFromBytes(byte[] byArray) {
        return (AuthenticatorErrorResponse)zzbgq.zza((byte[])byArray, CREATOR);
    }

    @Override
    public byte[] serializeToBytes() {
        return zzbgq.zza((zzbgp)this);
    }

    AuthenticatorErrorResponse(int n, String string) {
        try {
            this.zza = ErrorCode.toErrorCode(n);
        }
        catch (ErrorCode.UnsupportedErrorCodeException unsupportedErrorCodeException) {
            throw new IllegalArgumentException(unsupportedErrorCodeException);
        }
        this.zzb = string;
    }

    public ErrorCode getErrorCode() {
        return this.zza;
    }

    public int getErrorCodeAsInt() {
        return this.zza.getCode();
    }

    public String getErrorMessage() {
        return this.zzb;
    }

    @Override
    public byte[] getClientDataJSON() {
        throw new UnsupportedOperationException();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AuthenticatorErrorResponse authenticatorErrorResponse = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (int)authenticatorErrorResponse.getErrorCodeAsInt());
        zzbgo.zza((Parcel)parcel2, (int)3, (String)authenticatorErrorResponse.getErrorMessage(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        AuthenticatorErrorResponse authenticatorErrorResponse = (AuthenticatorErrorResponse)((Object)object);
        return zzbg.zza((Object)((Object)this.zza), (Object)((Object)authenticatorErrorResponse.zza)) && zzbg.zza((Object)this.zzb, (Object)authenticatorErrorResponse.zzb);
    }

    public static final class Builder {
        private ErrorCode zza;
        private String zzb;

        public Builder() {
        }

        public final Builder setErrorCode(ErrorCode errorCode) {
            this.zza = errorCode;
            return this;
        }

        public final Builder setErrorMessage(String string) {
            this.zzb = string;
            return this;
        }

        public final AuthenticatorErrorResponse build() {
            return new AuthenticatorErrorResponse(this.zza.getCode(), this.zzb);
        }
    }
}

