/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.fido2.api.common.zzs;
import com.google.android.gms.fido.fido2.api.common.zzt;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import org.json.JSONException;
import org.json.JSONObject;

public class TokenBindingIdValue
extends zzbgl {
    @Hide
    public static final Parcelable.Creator<TokenBindingIdValue> CREATOR = new zzt();
    public static final TokenBindingIdValue ABSENT = new TokenBindingIdValue();
    public static final TokenBindingIdValue UNAVAILABLE = new TokenBindingIdValue("unavailable");
    public static final TokenBindingIdValue UNUSED = new TokenBindingIdValue("unused");
    private final TokenBindingIdValueType zza;
    private final String zzb;
    private final String zzc;

    TokenBindingIdValue(int n, String string, String string2) {
        try {
            this.zza = TokenBindingIdValue.toTokenBindingIdValueType(n);
        }
        catch (UnsupportedTokenBindingIdValueTypeException unsupportedTokenBindingIdValueTypeException) {
            throw new IllegalArgumentException(unsupportedTokenBindingIdValueTypeException);
        }
        this.zzb = string;
        this.zzc = string2;
    }

    public TokenBindingIdValue(JSONObject jSONObject) {
        this.zzc = (String)zzbq.zza((Object)jSONObject.toString());
        this.zza = TokenBindingIdValueType.OBJECT;
        this.zzb = null;
    }

    private TokenBindingIdValue() {
        this.zza = TokenBindingIdValueType.ABSENT;
        this.zzc = null;
        this.zzb = null;
    }

    private TokenBindingIdValue(String string) {
        this.zzb = (String)zzbq.zza((Object)string);
        this.zza = TokenBindingIdValueType.STRING;
        this.zzc = null;
    }

    public static TokenBindingIdValueType toTokenBindingIdValueType(int n) throws UnsupportedTokenBindingIdValueTypeException {
        for (TokenBindingIdValueType tokenBindingIdValueType : TokenBindingIdValueType.values()) {
            if (n != tokenBindingIdValueType.zza) continue;
            return tokenBindingIdValueType;
        }
        throw new UnsupportedTokenBindingIdValueTypeException(n);
    }

    public int getTypeAsInt() {
        return this.zza.zza;
    }

    public TokenBindingIdValueType getType() {
        return this.zza;
    }

    public String getObjectValueAsString() {
        return this.zzc;
    }

    public JSONObject getObjectValue() {
        if (this.zzc == null) {
            return null;
        }
        try {
            return new JSONObject(this.zzc);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public String getStringValue() {
        return this.zzb;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        TokenBindingIdValue tokenBindingIdValue = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (int)tokenBindingIdValue.getTypeAsInt());
        zzbgo.zza((Parcel)parcel2, (int)3, (String)tokenBindingIdValue.getStringValue(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)tokenBindingIdValue.getObjectValueAsString(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TokenBindingIdValue)) {
            return false;
        }
        TokenBindingIdValue tokenBindingIdValue = (TokenBindingIdValue)((Object)object);
        if (!this.zza.equals((Object)tokenBindingIdValue.zza)) {
            return false;
        }
        switch (this.zza) {
            case ABSENT: {
                return true;
            }
            case STRING: {
                return this.zzb.equals(tokenBindingIdValue.zzb);
            }
            case OBJECT: {
                return this.zzc.equals(tokenBindingIdValue.zzc);
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 31 + this.zza.hashCode();
        switch (this.zza) {
            case ABSENT: {
                break;
            }
            case STRING: {
                n = n * 31 + this.zzb.hashCode();
                break;
            }
            case OBJECT: {
                n = n * 31 + this.zzc.hashCode();
            }
        }
        return n;
    }

    public static class UnsupportedTokenBindingIdValueTypeException
    extends Exception {
        public UnsupportedTokenBindingIdValueTypeException(int n) {
            super(String.format("TokenBindingIdValueType %s not supported", n));
        }
    }

    public static enum TokenBindingIdValueType implements Parcelable
    {
        ABSENT(0),
        STRING(1),
        OBJECT(2);

        public static final Parcelable.Creator<TokenBindingIdValueType> CREATOR;
        private final int zza;

        private TokenBindingIdValueType(int n2) {
            this.zza = n2;
        }

        public final int describeContents() {
            return 0;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.zza);
        }

        static {
            CREATOR = new zzs();
        }
    }
}

