/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.zzb;
import com.google.android.gms.fido.u2f.api.common.zzc;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelIdValue
extends zzbgl {
    @Hide
    public static final Parcelable.Creator<ChannelIdValue> CREATOR = new zzc();
    public static final ChannelIdValue ABSENT = new ChannelIdValue();
    public static final ChannelIdValue UNAVAILABLE = new ChannelIdValue("unavailable");
    public static final ChannelIdValue UNUSED = new ChannelIdValue("unused");
    private final ChannelIdValueType zza;
    private final String zzb;
    private final String zzc;

    ChannelIdValue(int n, String string, String string2) {
        try {
            this.zza = ChannelIdValue.toChannelIdValueType(n);
        }
        catch (UnsupportedChannelIdValueTypeException unsupportedChannelIdValueTypeException) {
            throw new IllegalArgumentException(unsupportedChannelIdValueTypeException);
        }
        this.zzb = string;
        this.zzc = string2;
    }

    public ChannelIdValue(JSONObject jSONObject) {
        this.zzc = (String)zzbq.zza((Object)jSONObject.toString());
        this.zza = ChannelIdValueType.OBJECT;
        this.zzb = null;
    }

    private ChannelIdValue() {
        this.zza = ChannelIdValueType.ABSENT;
        this.zzc = null;
        this.zzb = null;
    }

    private ChannelIdValue(String string) {
        this.zzb = (String)zzbq.zza((Object)string);
        this.zza = ChannelIdValueType.STRING;
        this.zzc = null;
    }

    public static ChannelIdValueType toChannelIdValueType(int n) throws UnsupportedChannelIdValueTypeException {
        for (ChannelIdValueType channelIdValueType : ChannelIdValueType.values()) {
            if (n != channelIdValueType.zza) continue;
            return channelIdValueType;
        }
        throw new UnsupportedChannelIdValueTypeException(n);
    }

    public int getTypeAsInt() {
        return this.zza.zza;
    }

    public ChannelIdValueType getType() {
        return this.zza;
    }

    public String getObjectValueAsString() {
        return this.zzc;
    }

    public JSONObject getObjectValue() {
        if (this.zzc == null) {
            return null;
        }
        try {
            return new JSONObject(this.zzc);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public String getStringValue() {
        return this.zzb;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ChannelIdValue channelIdValue = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (int)channelIdValue.getTypeAsInt());
        zzbgo.zza((Parcel)parcel2, (int)3, (String)channelIdValue.getStringValue(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)channelIdValue.getObjectValueAsString(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChannelIdValue)) {
            return false;
        }
        ChannelIdValue channelIdValue = (ChannelIdValue)((Object)object);
        if (!this.zza.equals((Object)channelIdValue.zza)) {
            return false;
        }
        switch (this.zza) {
            case ABSENT: {
                return true;
            }
            case STRING: {
                return this.zzb.equals(channelIdValue.zzb);
            }
            case OBJECT: {
                return this.zzc.equals(channelIdValue.zzc);
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 31 + this.zza.hashCode();
        switch (this.zza) {
            case ABSENT: {
                break;
            }
            case STRING: {
                n = n * 31 + this.zzb.hashCode();
                break;
            }
            case OBJECT: {
                n = n * 31 + this.zzc.hashCode();
            }
        }
        return n;
    }

    public static class UnsupportedChannelIdValueTypeException
    extends Exception {
        public UnsupportedChannelIdValueTypeException(int n) {
            super(String.format("ChannelIdValueType %s not supported", n));
        }
    }

    public static enum ChannelIdValueType implements Parcelable
    {
        ABSENT(0),
        STRING(1),
        OBJECT(2);

        public static final Parcelable.Creator<ChannelIdValueType> CREATOR;
        private final int zza;

        private ChannelIdValueType(int n2) {
            this.zza = n2;
        }

        public final int describeContents() {
            return 0;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.zza);
        }

        static {
            CREATOR = new zzb();
        }
    }
}

