/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.fido2.api.common.BrowserRequestOptions;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialRequestOptions;
import com.google.android.gms.fido.fido2.api.common.RequestOptions;
import com.google.android.gms.fido.fido2.api.common.TokenBindingIdValue;
import com.google.android.gms.fido.fido2.api.common.zzi;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbgp;
import com.google.android.gms.internal.zzbgq;
import java.util.Arrays;

public class BrowserPublicKeyCredentialRequestOptions
extends BrowserRequestOptions {
    @Hide
    public static final Parcelable.Creator<BrowserPublicKeyCredentialRequestOptions> CREATOR = new zzi();
    private final PublicKeyCredentialRequestOptions zzhew;
    private final Uri zzheu;

    BrowserPublicKeyCredentialRequestOptions(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, Uri uri) {
        this.zzhew = (PublicKeyCredentialRequestOptions)((Object)zzbq.checkNotNull((Object)((Object)publicKeyCredentialRequestOptions)));
        zzbq.checkNotNull((Object)uri);
        zzbq.checkArgument((uri.getScheme() != null ? 1 : 0) != 0, (Object)"origin scheme must be non-empty");
        zzbq.checkArgument((uri.getAuthority() != null ? 1 : 0) != 0, (Object)"origin authority must be non-empty");
        this.zzheu = uri;
    }

    public static BrowserPublicKeyCredentialRequestOptions deserializeFromBytes(byte[] byArray) {
        return (BrowserPublicKeyCredentialRequestOptions)zzbgq.zza((byte[])byArray, CREATOR);
    }

    @Override
    public byte[] serializeToBytes() {
        return zzbgq.zza((zzbgp)this);
    }

    public PublicKeyCredentialRequestOptions getPublicKeyCredentialRequestOptions() {
        return this.zzhew;
    }

    @Override
    public byte[] getChallenge() {
        return ((RequestOptions)this.zzhew).getChallenge();
    }

    @Override
    public Double getTimeoutSeconds() {
        return ((RequestOptions)this.zzhew).getTimeoutSeconds();
    }

    @Override
    public Integer getRequestId() {
        return ((RequestOptions)this.zzhew).getRequestId();
    }

    @Override
    public TokenBindingIdValue getTokenBindingIdValue() {
        return ((RequestOptions)this.zzhew).getTokenBindingIdValue();
    }

    @Override
    public Uri getOrigin() {
        return this.zzheu;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        BrowserPublicKeyCredentialRequestOptions browserPublicKeyCredentialRequestOptions = (BrowserPublicKeyCredentialRequestOptions)((Object)object);
        return zzbg.equal((Object)((Object)this.zzhew), (Object)((Object)browserPublicKeyCredentialRequestOptions.zzhew)) && zzbg.equal((Object)this.zzheu, (Object)browserPublicKeyCredentialRequestOptions.zzheu);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhew, this.zzheu});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        BrowserPublicKeyCredentialRequestOptions browserPublicKeyCredentialRequestOptions = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable)browserPublicKeyCredentialRequestOptions.getPublicKeyCredentialRequestOptions(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)((BrowserRequestOptions)browserPublicKeyCredentialRequestOptions).getOrigin(), (int)n, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private PublicKeyCredentialRequestOptions zzhex;
        private Uri zzheu;

        public Builder() {
        }

        public final Builder setRequestOptions(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions) {
            this.zzhex = publicKeyCredentialRequestOptions;
            return this;
        }

        public final Builder setOrigin(Uri uri) {
            this.zzheu = uri;
            return this;
        }

        public final BrowserPublicKeyCredentialRequestOptions build() {
            return new BrowserPublicKeyCredentialRequestOptions(this.zzhex, this.zzheu);
        }
    }
}

