/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.fido.fido2.api.common.AuthenticationExtensions;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialDescriptor;
import com.google.android.gms.fido.fido2.api.common.RequestOptions;
import com.google.android.gms.fido.fido2.api.common.TokenBinding;
import com.google.android.gms.fido.fido2.api.common.zzaj;
import com.google.android.gms.fido.fido2.api.common.zzas;
import com.google.android.gms.fido.fido2.api.common.zzat;
import java.util.Arrays;
import java.util.List;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="PublicKeyCredentialRequestOptionsCreator")
public class PublicKeyCredentialRequestOptions
extends RequestOptions {
    @NonNull
    public static final Parcelable.Creator<PublicKeyCredentialRequestOptions> CREATOR = new zzaj();
    @NonNull
    @SafeParcelable.Field(id=2, getter="getChallenge")
    private final byte[] zza;
    @Nullable
    @SafeParcelable.Field(id=3, getter="getTimeoutSeconds")
    private final Double zzb;
    @NonNull
    @SafeParcelable.Field(id=4, getter="getRpId")
    private final String zzc;
    @Nullable
    @SafeParcelable.Field(id=5, getter="getAllowList")
    private final List zzd;
    @Nullable
    @SafeParcelable.Field(id=6, getter="getRequestId")
    private final Integer zze;
    @Nullable
    @SafeParcelable.Field(id=7, getter="getTokenBinding")
    private final TokenBinding zzf;
    @Nullable
    @SafeParcelable.Field(id=8, getter="getUserVerificationAsString", type="java.lang.String")
    private final zzat zzg;
    @Nullable
    @SafeParcelable.Field(id=9, getter="getAuthenticationExtensions")
    private final AuthenticationExtensions zzh;
    @Nullable
    @SafeParcelable.Field(id=10, getter="getLongRequestId")
    private final Long zzi;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Arrays.hashCode(this.zza), this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi});
    }

    @Override
    @Nullable
    public AuthenticationExtensions getAuthenticationExtensions() {
        return this.zzh;
    }

    @NonNull
    public static PublicKeyCredentialRequestOptions deserializeFromBytes(@Nullable byte[] serializedBytes) {
        return (PublicKeyCredentialRequestOptions)SafeParcelableSerializer.deserializeFromBytes((byte[])serializedBytes, CREATOR);
    }

    @Override
    @Nullable
    public TokenBinding getTokenBinding() {
        return this.zzf;
    }

    @Override
    @Nullable
    public Double getTimeoutSeconds() {
        return this.zzb;
    }

    @Override
    @Nullable
    public Integer getRequestId() {
        return this.zze;
    }

    @NonNull
    public String getRpId() {
        return this.zzc;
    }

    @Nullable
    public List<PublicKeyCredentialDescriptor> getAllowList() {
        return this.zzd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SafeParcelable.Constructor
    PublicKeyCredentialRequestOptions(@NonNull @SafeParcelable.Param(id=2) byte[] byArray, @Nullable @SafeParcelable.Param(id=3) Double d, @NonNull @SafeParcelable.Param(id=4) String string, @Nullable @SafeParcelable.Param(id=5) List list, @Nullable @SafeParcelable.Param(id=6) Integer n, @Nullable @SafeParcelable.Param(id=7) TokenBinding tokenBinding, @Nullable @SafeParcelable.Param(id=8) String string2, @Nullable @SafeParcelable.Param(id=9) AuthenticationExtensions authenticationExtensions, @Nullable @SafeParcelable.Param(id=10) Long l) {
        this.zza = (byte[])Preconditions.checkNotNull((Object)byArray);
        this.zzb = d;
        this.zzc = (String)Preconditions.checkNotNull((Object)string);
        this.zzd = list;
        this.zze = n;
        this.zzf = tokenBinding;
        this.zzi = l;
        if (string2 != null) {
            try {
                this.zzg = zzat.zza(string2);
            }
            catch (zzas zzas2) {
                throw new IllegalArgumentException(zzas2);
            }
        } else {
            this.zzg = null;
        }
        this.zzh = authenticationExtensions;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var3_6;
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)2, (byte[])this.getChallenge(), (boolean)false);
        SafeParcelWriter.writeDoubleObject((Parcel)var1_1, (int)3, (Double)this.getTimeoutSeconds(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)this.getRpId(), (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)5, this.getAllowList(), (boolean)false);
        SafeParcelWriter.writeIntegerObject((Parcel)var1_1, (int)6, (Integer)this.getRequestId(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)7, (Parcelable)this.getTokenBinding(), (int)var2_2, (boolean)false);
        zzat zzat2 = this.zzg;
        if (zzat2 == null) {
            Object var3_5 = null;
        } else {
            String string = zzat2.toString();
        }
        SafeParcelWriter.writeString((Parcel)var1_1, (int)8, (String)var3_6, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)9, (Parcelable)this.getAuthenticationExtensions(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)var1_1, (int)10, (Long)this.zzi, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@NonNull Object obj) {
        List list;
        List list2;
        PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions;
        if (!(obj instanceof PublicKeyCredentialRequestOptions)) {
            return false;
        }
        publicKeyCredentialRequestOptions = publicKeyCredentialRequestOptions;
        return Arrays.equals(this.zza, publicKeyCredentialRequestOptions.zza) && Objects.equal((Object)this.zzb, (Object)publicKeyCredentialRequestOptions.zzb) && Objects.equal((Object)this.zzc, (Object)publicKeyCredentialRequestOptions.zzc) && ((list2 = this.zzd) == null && publicKeyCredentialRequestOptions.zzd == null || list2 != null && (list = publicKeyCredentialRequestOptions.zzd) != null && list2.containsAll(list) && publicKeyCredentialRequestOptions.zzd.containsAll(this.zzd)) && Objects.equal((Object)this.zze, (Object)publicKeyCredentialRequestOptions.zze) && Objects.equal((Object)((Object)this.zzf), (Object)((Object)publicKeyCredentialRequestOptions.zzf)) && Objects.equal((Object)((Object)this.zzg), (Object)((Object)publicKeyCredentialRequestOptions.zzg)) && Objects.equal((Object)((Object)this.zzh), (Object)((Object)publicKeyCredentialRequestOptions.zzh)) && Objects.equal((Object)this.zzi, (Object)publicKeyCredentialRequestOptions.zzi);
    }

    @Override
    @NonNull
    public byte[] getChallenge() {
        return this.zza;
    }

    @Override
    @NonNull
    public byte[] serializeToBytes() {
        return SafeParcelableSerializer.serializeToBytes((SafeParcelable)this);
    }

    @Nullable
    public final zzat zza() {
        return this.zzg;
    }

    public static final class Builder {
        private byte[] zza;
        private Double zzb;
        private String zzc;
        private List zzd;
        private Integer zze;
        private TokenBinding zzf;
        private zzat zzg;
        private AuthenticationExtensions zzh;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAllowList(@Nullable List<PublicKeyCredentialDescriptor> allowList) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAuthenticationExtensions(@Nullable AuthenticationExtensions authenticationExtensions) {
            void var1_1;
            this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setChallenge(@NonNull byte[] challenge) {
            void var1_1;
            this.zza = (byte[])Preconditions.checkNotNull((Object)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRequestId(@Nullable Integer requestId) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRpId(@NonNull String rpId) {
            void var1_1;
            this.zzc = (String)Preconditions.checkNotNull((Object)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTimeoutSeconds(@Nullable Double timeoutSeconds) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTokenBinding(@Nullable TokenBinding tokenBinding) {
            void var1_1;
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public PublicKeyCredentialRequestOptions build() {
            void var1_10;
            byte[] byArray = this.zza;
            Double d = this.zzb;
            String string = this.zzc;
            List list = this.zzd;
            Integer n = this.zze;
            TokenBinding tokenBinding = this.zzf;
            zzat zzat2 = this.zzg;
            if (zzat2 == null) {
                Object var1_9 = null;
                return new PublicKeyCredentialRequestOptions(byArray, d, string, list, n, tokenBinding, (String)var1_10, this.zzh, null);
            }
            String string2 = zzat2.toString();
            return new PublicKeyCredentialRequestOptions(byArray, d, string, list, n, tokenBinding, (String)var1_10, this.zzh, null);
        }

        public Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@Nullable PublicKeyCredentialRequestOptions requestOptions) {
            void var1_1;
            if (var1_1 != null) {
                this.zza = var1_1.getChallenge();
                this.zzb = var1_1.getTimeoutSeconds();
                this.zzc = var1_1.getRpId();
                this.zzd = var1_1.getAllowList();
                this.zze = var1_1.getRequestId();
                this.zzf = var1_1.getTokenBinding();
                this.zzg = var1_1.zza();
                this.zzh = var1_1.getAuthenticationExtensions();
                return;
            }
        }
    }
}

