/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fido.fido2.api.common.COSEAlgorithmIdentifier;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialType;
import com.google.android.gms.fido.fido2.api.common.zzai;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="PublicKeyCredentialParametersCreator")
public class PublicKeyCredentialParameters
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<PublicKeyCredentialParameters> CREATOR = new zzai();
    @SafeParcelable.Field(id=2, getter="getTypeAsString", type="java.lang.String")
    @NonNull
    private final PublicKeyCredentialType zza;
    @SafeParcelable.Field(id=3, getter="getAlgorithmIdAsInteger", type="java.lang.Integer")
    @NonNull
    private final COSEAlgorithmIdentifier zzb;

    public int getAlgorithmIdAsInteger() {
        return this.zzb.toCoseValue();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb});
    }

    @NonNull
    public COSEAlgorithmIdentifier getAlgorithm() {
        return this.zzb;
    }

    @NonNull
    public PublicKeyCredentialType getType() {
        return this.zza;
    }

    @NonNull
    public String getTypeAsString() {
        return this.zza.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SafeParcelable.Constructor
    public PublicKeyCredentialParameters(@NonNull @SafeParcelable.Param(id=2) String type, @SafeParcelable.Param(id=3) int algorithm) {
        void var2_4;
        void var1_3;
        Preconditions.checkNotNull((Object)var1_3);
        try {
            this.zza = PublicKeyCredentialType.fromString((String)var1_3);
        }
        catch (PublicKeyCredentialType.UnsupportedPublicKeyCredTypeException unsupportedPublicKeyCredTypeException) {
            throw new IllegalArgumentException(unsupportedPublicKeyCredTypeException);
        }
        Preconditions.checkNotNull((Object)((int)var2_4));
        try {}
        catch (COSEAlgorithmIdentifier.UnsupportedAlgorithmIdentifierException unsupportedAlgorithmIdentifierException) {
            throw new IllegalArgumentException(unsupportedAlgorithmIdentifierException);
        }
        this.zzb = COSEAlgorithmIdentifier.fromCoseValue((int)var2_4);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getTypeAsString(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeIntegerObject((Parcel)v1, (int)3, (Integer)this.getAlgorithmIdAsInteger(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@NonNull Object obj) {
        PublicKeyCredentialParameters publicKeyCredentialParameters;
        if (!(obj instanceof PublicKeyCredentialParameters)) {
            return false;
        }
        publicKeyCredentialParameters = publicKeyCredentialParameters;
        return this.zza.equals((Object)publicKeyCredentialParameters.zza) && this.zzb.equals(publicKeyCredentialParameters.zzb);
    }
}

