/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fido.fido2.api.common.zzat;
import com.google.android.gms.fido.fido2.api.common.zzau;
import com.google.android.gms.internal.fido.zzal;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="TokenBindingCreator")
public class TokenBinding
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<TokenBinding> CREATOR = new zzau();
    @NonNull
    public static final TokenBinding SUPPORTED = new TokenBinding(TokenBindingStatus.SUPPORTED.toString(), null);
    @NonNull
    public static final TokenBinding NOT_SUPPORTED = new TokenBinding(TokenBindingStatus.NOT_SUPPORTED.toString(), null);
    @NonNull
    @SafeParcelable.Field(id=2, getter="getTokenBindingStatusAsString", type="java.lang.String")
    private final TokenBindingStatus zza;
    @Nullable
    @SafeParcelable.Field(id=3, getter="getTokenBindingId")
    private final String zzb;

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb});
    }

    @Nullable
    public String getTokenBindingId() {
        return this.zzb;
    }

    @NonNull
    public String getTokenBindingStatusAsString() {
        return this.zza.toString();
    }

    @NonNull
    public JSONObject toJsonObject() throws JSONException {
        try {
            TokenBinding tokenBinding = new JSONObject().put("status", (Object)tokenBinding.zza).put("id", (Object)tokenBinding.zzb);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        return tokenBinding;
    }

    /*
     * WARNING - void declaration
     */
    public TokenBinding(@NonNull String tokenBindingId) {
        this(TokenBindingStatus.PRESENT.toString(), (String)Preconditions.checkNotNull((Object)var1_1));
        void var1_1;
    }

    @SafeParcelable.Constructor
    TokenBinding(@NonNull @SafeParcelable.Param(id=2) String string, @Nullable @SafeParcelable.Param(id=3) String string2) {
        Preconditions.checkNotNull((Object)string);
        try {
            this.zza = TokenBindingStatus.fromString(string);
        }
        catch (UnsupportedTokenBindingStatusException unsupportedTokenBindingStatusException) {
            throw new IllegalArgumentException(unsupportedTokenBindingStatusException);
        }
        this.zzb = string2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getTokenBindingStatusAsString(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)3, (String)this.getTokenBindingId(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@NonNull Object obj) {
        TokenBinding tokenBinding;
        if (!(obj instanceof TokenBinding)) {
            return false;
        }
        tokenBinding = tokenBinding;
        return zzal.zza((Object)this.zza, (Object)tokenBinding.zza) && zzal.zza(this.zzb, tokenBinding.zzb);
    }

    public static final class TokenBindingStatus
    extends Enum<TokenBindingStatus>
    implements Parcelable {
        @NonNull
        public static final /* enum */ TokenBindingStatus PRESENT;
        @NonNull
        public static final /* enum */ TokenBindingStatus SUPPORTED;
        @NonNull
        public static final /* enum */ TokenBindingStatus NOT_SUPPORTED;
        @NonNull
        public static final Parcelable.Creator<TokenBindingStatus> CREATOR;
        private static final /* synthetic */ TokenBindingStatus[] zza;
        @NonNull
        private final String zzb;

        public int describeContents() {
            return 0;
        }

        @NonNull
        public static TokenBindingStatus fromString(@NonNull String tokenBindingStatusAsString) throws UnsupportedTokenBindingStatusException {
            TokenBindingStatus[] tokenBindingStatusArray = TokenBindingStatus.values();
            int n = tokenBindingStatusArray.length;
            int n2 = 0;
            while (true) {
                String string;
                if (n2 < n) {
                    TokenBindingStatus tokenBindingStatus = tokenBindingStatusArray[n2];
                    if (string.equals(tokenBindingStatus.zzb)) {
                        return tokenBindingStatus;
                    }
                } else {
                    throw new UnsupportedTokenBindingStatusException(string);
                }
                ++n2;
            }
        }

        @NonNull
        public static TokenBindingStatus valueOf(@NonNull String name) {
            String string;
            return Enum.valueOf(TokenBindingStatus.class, string);
        }

        @NonNull
        public String toString() {
            return this.zzb;
        }

        static {
            String string = "present";
            PRESENT = new TokenBindingStatus(string);
            string = "supported";
            SUPPORTED = new TokenBindingStatus(string);
            string = "not-supported";
            NOT_SUPPORTED = new TokenBindingStatus(string);
            zza = new TokenBindingStatus[]{PRESENT, SUPPORTED, NOT_SUPPORTED};
            CREATOR = new zzat();
        }

        private TokenBindingStatus(String string2) {
            this.zzb = string2;
        }

        public void writeToParcel(@NonNull Parcel parcel, int n) {
            parcel.writeString(this.zzb);
        }

        @NonNull
        public static TokenBindingStatus[] values() {
            return (TokenBindingStatus[])zza.clone();
        }
    }

    public static class UnsupportedTokenBindingStatusException
    extends Exception {
        /*
         * WARNING - void declaration
         */
        public UnsupportedTokenBindingStatusException(@NonNull String unsupportedTokenBindingStatus) {
            void var1_1;
            Object[] objectArray = new Object[]{var1_1};
            super(String.format("TokenBindingStatus %s not supported", objectArray));
        }
    }
}

